/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.response.error.AlreadyExists;
import com.datastax.oss.protocol.internal.response.error.FunctionFailure;
import com.datastax.oss.protocol.internal.response.error.ReadFailure;
import com.datastax.oss.protocol.internal.response.error.ReadTimeout;
import com.datastax.oss.protocol.internal.response.error.Unavailable;
import com.datastax.oss.protocol.internal.response.error.Unprepared;
import com.datastax.oss.protocol.internal.response.error.WriteFailure;
import com.datastax.oss.protocol.internal.response.error.WriteTimeout;
import com.datastax.oss.protocol.internal.util.IntMap;

public class Error
extends Message {
    public final int code;
    public final String message;

    public Error(int code, String message) {
        super(true, 0);
        this.code = code;
        this.message = message;
    }

    public String toString() {
        return "ERROR(" + this.message + ")";
    }

    public static class SingleMessageSubCodec
    extends SubCodec {
        public SingleMessageSubCodec(int errorCode2, int protocolVersion) {
            super(errorCode2, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Error error2 = (Error)message;
            encoder2.writeString(error2.message, dest);
        }

        @Override
        public int encodedSize(Message message) {
            Error error2 = (Error)message;
            return PrimitiveSizes.sizeOfString(error2.message);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String message = decoder2.readString(source);
            return new Error(this.errorCode, message);
        }
    }

    public static abstract class SubCodec {
        protected final int errorCode;
        protected final int protocolVersion;

        protected SubCodec(int errorCode2, int protocolVersion) {
            this.errorCode = errorCode2;
            this.protocolVersion = protocolVersion;
        }

        public abstract <B> void encode(B var1, Message var2, PrimitiveCodec<B> var3);

        public abstract int encodedSize(Message var1);

        public abstract <B> Message decode(B var1, PrimitiveCodec<B> var2);
    }

    public static class Codec
    extends Message.Codec {
        private final IntMap<SubCodec> subCodecs;

        public Codec(int protocolVersion, SubCodec ... subCodecs) {
            super(0, protocolVersion);
            IntMap.Builder<SubCodec> builder = IntMap.builder();
            for (SubCodec subCodec : subCodecs) {
                builder.put(subCodec.errorCode, subCodec);
            }
            this.subCodecs = builder.build();
        }

        public Codec(int protocolVersion) {
            this(protocolVersion, new SingleMessageSubCodec(0, protocolVersion), new SingleMessageSubCodec(10, protocolVersion), new SingleMessageSubCodec(256, protocolVersion), new SingleMessageSubCodec(4097, protocolVersion), new SingleMessageSubCodec(4098, protocolVersion), new SingleMessageSubCodec(4099, protocolVersion), new SingleMessageSubCodec(8192, protocolVersion), new SingleMessageSubCodec(8448, protocolVersion), new SingleMessageSubCodec(8704, protocolVersion), new SingleMessageSubCodec(8960, protocolVersion), new Unavailable.SubCodec(protocolVersion), new WriteTimeout.SubCodec(protocolVersion), new ReadTimeout.SubCodec(protocolVersion), new ReadFailure.SubCodec(protocolVersion), new FunctionFailure.SubCodec(protocolVersion), new WriteFailure.SubCodec(protocolVersion), new AlreadyExists.SubCodec(protocolVersion), new Unprepared.SubCodec(protocolVersion));
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Error error2 = (Error)message;
            encoder2.writeInt(error2.code, dest);
            this.getSubCodec(error2.code).encode(dest, message, encoder2);
        }

        @Override
        public int encodedSize(Message message) {
            Error error2 = (Error)message;
            return 4 + this.getSubCodec(error2.code).encodedSize(message);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            int errorCode2 = decoder2.readInt(source);
            return this.getSubCodec(errorCode2).decode(source, decoder2);
        }

        private SubCodec getSubCodec(int errorCode2) {
            SubCodec subCodec = this.subCodecs.get(errorCode2);
            ProtocolErrors.check(subCodec != null, "Unsupported error code: %d", errorCode2);
            return subCodec;
        }
    }
}

