/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request.query;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolConstants;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Values {
    public static <B> void writePositionalValues(List<ByteBuffer> values2, B dest, PrimitiveCodec<B> encoder2) {
        encoder2.writeUnsignedShort(values2.size(), dest);
        for (ByteBuffer value2 : values2) {
            Values.writeValue(value2, dest, encoder2);
        }
    }

    public static int sizeOfPositionalValues(List<ByteBuffer> values2) {
        int size2 = 2;
        for (ByteBuffer value2 : values2) {
            size2 += Values.sizeOfValue(value2);
        }
        return size2;
    }

    public static <B> void writeNamedValues(Map<String, ByteBuffer> values2, B dest, PrimitiveCodec<B> encoder2) {
        encoder2.writeUnsignedShort(values2.size(), dest);
        for (Map.Entry<String, ByteBuffer> entry2 : values2.entrySet()) {
            encoder2.writeString(entry2.getKey(), dest);
            Values.writeValue(entry2.getValue(), dest, encoder2);
        }
    }

    public static int sizeOfNamedValues(Map<String, ByteBuffer> values2) {
        int size2 = 2;
        for (Map.Entry<String, ByteBuffer> entry2 : values2.entrySet()) {
            size2 += PrimitiveSizes.sizeOfString(entry2.getKey());
            size2 += Values.sizeOfValue(entry2.getValue());
        }
        return size2;
    }

    private static <B> void writeValue(ByteBuffer value2, B dest, PrimitiveCodec<B> encoder2) {
        if (value2 == null) {
            encoder2.writeInt(-1, dest);
        } else if (value2 == ProtocolConstants.UNSET_VALUE) {
            encoder2.writeInt(-2, dest);
        } else {
            encoder2.writeBytes(value2, dest);
        }
    }

    private static int sizeOfValue(ByteBuffer value2) {
        return value2 == null || value2 == ProtocolConstants.UNSET_VALUE ? 4 : PrimitiveSizes.sizeOfBytes(value2);
    }

    public static <B> List<ByteBuffer> readPositionalValues(B source, PrimitiveCodec<B> decoder2) {
        int size2 = decoder2.readUnsignedShort(source);
        if (size2 == 0) {
            return Collections.emptyList();
        }
        NullAllowingImmutableList.Builder<ByteBuffer> values2 = NullAllowingImmutableList.builder(size2);
        for (int i = 0; i < size2; ++i) {
            values2.add(Values.readValue(source, decoder2));
        }
        return values2.build();
    }

    public static <B> Map<String, ByteBuffer> readNamedValues(B source, PrimitiveCodec<B> decoder2) {
        int size2 = decoder2.readUnsignedShort(source);
        if (size2 == 0) {
            return Collections.emptyMap();
        }
        NullAllowingImmutableMap.Builder<String, ByteBuffer> values2 = NullAllowingImmutableMap.builder(size2);
        for (int i = 0; i < size2; ++i) {
            String key = decoder2.readString(source);
            ByteBuffer value2 = Values.readValue(source, decoder2);
            values2.put(key, value2);
        }
        return values2.build();
    }

    public static <B> ByteBuffer readValue(B source, PrimitiveCodec<B> decoder2) {
        return decoder2.readBytes(source);
    }
}

