/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request.query;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QueryOptions {
    public static final long NO_DEFAULT_TIMESTAMP = Long.MIN_VALUE;
    public static final int NO_NOW_IN_SECONDS = Integer.MIN_VALUE;
    public static final QueryOptions DEFAULT = new QueryOptions(1, Collections.emptyList(), Collections.emptyMap(), false, -1, null, 8, Long.MIN_VALUE, null, Integer.MIN_VALUE);
    public final int flags;
    public final int consistency;
    public final List<ByteBuffer> positionalValues;
    public final Map<String, ByteBuffer> namedValues;
    public final boolean skipMetadata;
    public final int pageSize;
    public final ByteBuffer pagingState;
    public final int serialConsistency;
    public final long defaultTimestamp;
    public final String keyspace;
    public final int nowInSeconds;

    public QueryOptions(int flags2, int consistency2, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency2, long defaultTimestamp, String keyspace, int nowInSeconds) {
        ProtocolErrors.check(positionalValues.isEmpty() || namedValues.isEmpty(), "Can't have both positional and named values", new Object[0]);
        this.flags = flags2;
        this.consistency = consistency2;
        this.positionalValues = positionalValues;
        this.namedValues = namedValues;
        this.skipMetadata = skipMetadata;
        this.pageSize = pageSize;
        this.pagingState = pagingState;
        this.serialConsistency = serialConsistency2;
        this.defaultTimestamp = defaultTimestamp;
        this.keyspace = keyspace;
        this.nowInSeconds = nowInSeconds;
    }

    public QueryOptions(int consistency2, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency2, long defaultTimestamp, String keyspace, int nowInSeconds) {
        this(QueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, nowInSeconds), consistency2, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, nowInSeconds);
    }

    protected static int computeFlags(List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency2, long defaultTimestamp, String keyspace, int nowInSeconds) {
        int flags2 = 0;
        if (!positionalValues.isEmpty()) {
            flags2 = Flags.add(flags2, 1);
        }
        if (!namedValues.isEmpty()) {
            flags2 = Flags.add(flags2, 1);
            flags2 = Flags.add(flags2, 64);
        }
        if (skipMetadata) {
            flags2 = Flags.add(flags2, 2);
        }
        if (pageSize > 0) {
            flags2 = Flags.add(flags2, 4);
        }
        if (pagingState != null) {
            flags2 = Flags.add(flags2, 8);
        }
        if (serialConsistency2 != 8) {
            flags2 = Flags.add(flags2, 16);
        }
        if (defaultTimestamp != Long.MIN_VALUE) {
            flags2 = Flags.add(flags2, 32);
        }
        if (keyspace != null) {
            flags2 = Flags.add(flags2, 128);
        }
        if (nowInSeconds != Integer.MIN_VALUE) {
            flags2 = Flags.add(flags2, 256);
        }
        return flags2;
    }

    public String toString() {
        return String.format("[cl=%s, positionalVals=%s, namedVals=%s, skip=%b, psize=%d, state=%s, serialCl=%s]", this.consistency, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency);
    }

    public static int queryFlagsSize(int protocolVersion) {
        return protocolVersion >= 5 ? 4 : 1;
    }

    public static class Codec {
        public final int protocolVersion;

        public Codec(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public <B> void encode(B dest, QueryOptions options, PrimitiveCodec<B> encoder2) {
            encoder2.writeUnsignedShort(options.consistency, dest);
            if (this.protocolVersion >= 5) {
                encoder2.writeInt(options.flags, dest);
            } else {
                encoder2.writeByte((byte)options.flags, dest);
            }
            if (Flags.contains(options.flags, 1)) {
                if (Flags.contains(options.flags, 64)) {
                    Values.writeNamedValues(options.namedValues, dest, encoder2);
                } else {
                    Values.writePositionalValues(options.positionalValues, dest, encoder2);
                }
            }
            if (Flags.contains(options.flags, 4)) {
                encoder2.writeInt(options.pageSize, dest);
            }
            if (Flags.contains(options.flags, 8)) {
                encoder2.writeBytes(options.pagingState, dest);
            }
            if (Flags.contains(options.flags, 16)) {
                encoder2.writeUnsignedShort(options.serialConsistency, dest);
            }
            if (Flags.contains(options.flags, 32)) {
                encoder2.writeLong(options.defaultTimestamp, dest);
            }
            if (Flags.contains(options.flags, 128)) {
                encoder2.writeString(options.keyspace, dest);
            }
            if (Flags.contains(options.flags, 256)) {
                encoder2.writeInt(options.nowInSeconds, dest);
            }
        }

        public int encodedSize(QueryOptions options) {
            int size2 = 0;
            size2 += 2;
            size2 += QueryOptions.queryFlagsSize(this.protocolVersion);
            if (Flags.contains(options.flags, 1)) {
                size2 = Flags.contains(options.flags, 64) ? (size2 += Values.sizeOfNamedValues(options.namedValues)) : (size2 += Values.sizeOfPositionalValues(options.positionalValues));
            }
            if (Flags.contains(options.flags, 4)) {
                size2 += 4;
            }
            if (Flags.contains(options.flags, 8)) {
                size2 += PrimitiveSizes.sizeOfBytes(options.pagingState);
            }
            if (Flags.contains(options.flags, 16)) {
                size2 += 2;
            }
            if (Flags.contains(options.flags, 32)) {
                size2 += 8;
            }
            if (Flags.contains(options.flags, 128)) {
                size2 += PrimitiveSizes.sizeOfString(options.keyspace);
            }
            if (Flags.contains(options.flags, 256)) {
                size2 += 4;
            }
            return size2;
        }

        public <B> QueryOptions decode(B source, PrimitiveCodec<B> decoder2) {
            int consistency2 = decoder2.readUnsignedShort(source);
            int flags2 = this.protocolVersion >= 5 ? decoder2.readInt(source) : (int)decoder2.readByte(source);
            List<ByteBuffer> positionalValues = Collections.emptyList();
            Map<String, ByteBuffer> namedValues = Collections.emptyMap();
            if (Flags.contains(flags2, 1)) {
                if (Flags.contains(flags2, 64)) {
                    namedValues = Values.readNamedValues(source, decoder2);
                } else {
                    positionalValues = Values.readPositionalValues(source, decoder2);
                }
            }
            boolean skipMetadata = Flags.contains(flags2, 2);
            int pageSize = Flags.contains(flags2, 4) ? decoder2.readInt(source) : -1;
            ByteBuffer pagingState = Flags.contains(flags2, 8) ? decoder2.readBytes(source) : null;
            int serialConsistency2 = Flags.contains(flags2, 16) ? decoder2.readUnsignedShort(source) : 8;
            long defaultTimestamp = Flags.contains(flags2, 32) ? decoder2.readLong(source) : Long.MIN_VALUE;
            String keyspace = Flags.contains(flags2, 128) ? decoder2.readString(source) : null;
            int nowInSeconds = Flags.contains(flags2, 256) ? decoder2.readInt(source) : Integer.MIN_VALUE;
            return new QueryOptions(flags2, consistency2, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency2, defaultTimestamp, keyspace, nowInSeconds);
        }
    }
}

