/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;

public class Query
extends Message {
    public final String query;
    public final QueryOptions options;

    public Query(String query, QueryOptions options) {
        super(false, 7);
        this.query = query;
        this.options = options;
    }

    public Query(String query) {
        this(query, QueryOptions.DEFAULT);
    }

    public String toString() {
        return "QUERY (" + this.query + ')';
    }

    public static class Codec
    extends Message.Codec {
        protected final QueryOptions.Codec optionsCodec;

        public Codec(int protocolVersion, QueryOptions.Codec optionsCodec) {
            super(7, protocolVersion);
            this.optionsCodec = optionsCodec;
        }

        public Codec(int protocolVersion) {
            this(protocolVersion, new QueryOptions.Codec(protocolVersion));
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Query query = (Query)message;
            encoder2.writeLongString(query.query, dest);
            this.optionsCodec.encode(dest, query.options, encoder2);
        }

        @Override
        public int encodedSize(Message message) {
            Query query = (Query)message;
            return PrimitiveSizes.sizeOfLongString(query.query) + this.optionsCodec.encodedSize(query.options);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            String query = decoder2.readLongString(source);
            QueryOptions options = this.optionsCodec.decode(source, decoder2);
            return new Query(query, options);
        }
    }
}

