/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.util.Bytes;

public class Execute
extends Message {
    public final byte[] queryId;
    public final byte[] resultMetadataId;
    public final QueryOptions options;

    public Execute(byte[] queryId, byte[] resultMetadataId, QueryOptions options) {
        super(false, 10);
        this.queryId = queryId;
        this.resultMetadataId = resultMetadataId;
        this.options = options;
    }

    public Execute(byte[] queryId, QueryOptions options) {
        this(queryId, null, options);
    }

    public String toString() {
        return "EXECUTE(" + Bytes.toHexString(this.queryId) + ')';
    }

    public static class Codec
    extends Message.Codec {
        private final QueryOptions.Codec optionsCodec;

        public Codec(int protocolVersion, QueryOptions.Codec optionsCodec) {
            super(10, protocolVersion);
            this.optionsCodec = optionsCodec;
        }

        public Codec(int protocolVersion) {
            this(protocolVersion, new QueryOptions.Codec(protocolVersion));
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Execute execute2 = (Execute)message;
            encoder2.writeShortBytes(execute2.queryId, dest);
            if (this.protocolVersion >= 5) {
                encoder2.writeShortBytes(execute2.resultMetadataId, dest);
            }
            this.optionsCodec.encode(dest, execute2.options, encoder2);
        }

        @Override
        public int encodedSize(Message message) {
            Execute execute2 = (Execute)message;
            int size2 = PrimitiveSizes.sizeOfShortBytes(execute2.queryId);
            if (this.protocolVersion >= 5) {
                assert (execute2.resultMetadataId != null);
                size2 += PrimitiveSizes.sizeOfShortBytes(execute2.resultMetadataId);
            }
            return size2 += this.optionsCodec.encodedSize(execute2.options);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            byte[] queryId = decoder2.readShortBytes(source);
            byte[] resultMetadataId = this.protocolVersion >= 5 ? decoder2.readShortBytes(source) : null;
            QueryOptions options = this.optionsCodec.decode(source, decoder2);
            return new Execute(queryId, resultMetadataId, options);
        }
    }
}

