/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.request.query.Values;
import com.datastax.oss.protocol.internal.util.Flags;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import java.nio.ByteBuffer;
import java.util.List;

public class Batch
extends Message {
    public final byte type;
    public final List<Object> queriesOrIds;
    public final List<List<ByteBuffer>> values;
    public final int consistency;
    public final int serialConsistency;
    public final long defaultTimestamp;
    public final String keyspace;
    public final int nowInSeconds;
    public final int flags;

    public Batch(int flags2, byte type, List<Object> queriesOrIds, List<List<ByteBuffer>> values2, int consistency2, int serialConsistency2, long defaultTimestamp, String keyspace, int nowInSeconds) {
        super(false, 13);
        this.type = type;
        this.queriesOrIds = queriesOrIds;
        this.values = values2;
        this.consistency = consistency2;
        this.serialConsistency = serialConsistency2;
        this.defaultTimestamp = defaultTimestamp;
        this.keyspace = keyspace;
        this.nowInSeconds = nowInSeconds;
        this.flags = flags2;
    }

    public Batch(byte type, List<Object> queriesOrIds, List<List<ByteBuffer>> values2, int consistency2, int serialConsistency2, long defaultTimestamp, String keyspace, int nowInSeconds) {
        this(Batch.computeFlags(serialConsistency2, defaultTimestamp, keyspace, nowInSeconds), type, queriesOrIds, values2, consistency2, serialConsistency2, defaultTimestamp, keyspace, nowInSeconds);
    }

    public String toString() {
        return "BATCH(" + this.queriesOrIds.size() + " statements)";
    }

    protected static int computeFlags(int serialConsistency2, long defaultTimestamp, String keyspace, int nowInSeconds) {
        int flags2 = 0;
        if (serialConsistency2 != 8) {
            flags2 = Flags.add(flags2, 16);
        }
        if (defaultTimestamp != Long.MIN_VALUE) {
            flags2 = Flags.add(flags2, 32);
        }
        if (keyspace != null) {
            flags2 = Flags.add(flags2, 128);
        }
        if (nowInSeconds != Integer.MIN_VALUE) {
            flags2 = Flags.add(flags2, 256);
        }
        return flags2;
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(13, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            Batch batch2 = (Batch)message;
            encoder2.writeByte(batch2.type, dest);
            int queryCount = batch2.queriesOrIds.size();
            encoder2.writeUnsignedShort(queryCount, dest);
            for (int i = 0; i < queryCount; ++i) {
                Object q = batch2.queriesOrIds.get(i);
                if (q instanceof String) {
                    encoder2.writeByte((byte)0, dest);
                    encoder2.writeLongString((String)q, dest);
                } else {
                    encoder2.writeByte((byte)1, dest);
                    encoder2.writeShortBytes((byte[])q, dest);
                }
                Values.writePositionalValues(batch2.values.get(i), dest, encoder2);
            }
            encoder2.writeUnsignedShort(batch2.consistency, dest);
            if (this.protocolVersion >= 5) {
                encoder2.writeInt(batch2.flags, dest);
            } else {
                encoder2.writeByte((byte)batch2.flags, dest);
            }
            if (Flags.contains(batch2.flags, 16)) {
                encoder2.writeUnsignedShort(batch2.serialConsistency, dest);
            }
            if (Flags.contains(batch2.flags, 32)) {
                encoder2.writeLong(batch2.defaultTimestamp, dest);
            }
            if (Flags.contains(batch2.flags, 128)) {
                encoder2.writeString(batch2.keyspace, dest);
            }
            if (Flags.contains(batch2.flags, 256)) {
                encoder2.writeInt(batch2.nowInSeconds, dest);
            }
        }

        @Override
        public int encodedSize(Message message) {
            Batch batch2 = (Batch)message;
            int size2 = 1;
            size2 += 2;
            int queryCount = batch2.queriesOrIds.size();
            ProtocolErrors.check(queryCount <= 65535, "Batch messages can contain at most %d queries", 65535);
            ProtocolErrors.check(batch2.values.size() == queryCount, "Batch contains %d queries but %d value lists", queryCount, batch2.values.size());
            for (int i = 0; i < queryCount; ++i) {
                Object q = batch2.queriesOrIds.get(i);
                size2 += 1 + (q instanceof String ? PrimitiveSizes.sizeOfLongString((String)q) : PrimitiveSizes.sizeOfShortBytes((byte[])q));
                size2 += Values.sizeOfPositionalValues(batch2.values.get(i));
            }
            size2 += 2;
            size2 += this.protocolVersion >= 5 ? 4 : 1;
            if (Flags.contains(batch2.flags, 16)) {
                size2 += 2;
            }
            if (Flags.contains(batch2.flags, 32)) {
                size2 += 8;
            }
            if (Flags.contains(batch2.flags, 128)) {
                size2 += PrimitiveSizes.sizeOfString(batch2.keyspace);
            }
            if (Flags.contains(batch2.flags, 256)) {
                size2 += 4;
            }
            return size2;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            byte type = decoder2.readByte(source);
            int queryCount = decoder2.readUnsignedShort(source);
            NullAllowingImmutableList.Builder<Object> queriesOrIds = NullAllowingImmutableList.builder(queryCount);
            NullAllowingImmutableList.Builder<List<ByteBuffer>> values2 = NullAllowingImmutableList.builder(queryCount);
            for (int i = 0; i < queryCount; ++i) {
                boolean isQueryString = decoder2.readByte(source) == 0;
                queriesOrIds.add(isQueryString ? decoder2.readLongString(source) : (Object)decoder2.readShortBytes(source));
                values2.add(Values.readPositionalValues(source, decoder2));
            }
            int consistency2 = decoder2.readUnsignedShort(source);
            int flags2 = this.protocolVersion >= 5 ? decoder2.readInt(source) : (int)decoder2.readByte(source);
            int serialConsistency2 = Flags.contains(flags2, 16) ? decoder2.readUnsignedShort(source) : 8;
            long defaultTimestamp = Flags.contains(flags2, 32) ? decoder2.readLong(source) : Long.MIN_VALUE;
            String keyspace = Flags.contains(flags2, 128) ? decoder2.readString(source) : null;
            int nowInSeconds = Flags.contains(flags2, 256) ? decoder2.readInt(source) : Integer.MIN_VALUE;
            return new Batch(flags2, type, queriesOrIds.build(), values2.build(), consistency2, serialConsistency2, defaultTimestamp, keyspace, nowInSeconds);
        }
    }
}

