/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;

public class AuthResponse
extends Message {
    public final ByteBuffer token;

    public AuthResponse(ByteBuffer token2) {
        super(false, 15);
        this.token = token2;
    }

    public String toString() {
        return "AUTH_RESPONSE";
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(15, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder2) {
            AuthResponse authResponse = (AuthResponse)message;
            ByteBuffer token2 = authResponse.token;
            token2.mark();
            encoder2.writeBytes(token2, dest);
            token2.reset();
            Bytes.erase(token2);
        }

        @Override
        public int encodedSize(Message message) {
            AuthResponse authResponse = (AuthResponse)message;
            return PrimitiveSizes.sizeOfBytes(authResponse.token);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder2) {
            ByteBuffer token2 = decoder2.readBytes(source);
            return new AuthResponse(token2);
        }
    }
}

