/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.CrcMismatchException;
import com.datastax.oss.protocol.internal.NoopCompressor;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.Segment;
import com.datastax.oss.protocol.internal.util.Crc;
import java.util.List;

public class SegmentCodec<B> {
    private static final int COMPRESSED_HEADER_LENGTH = 5;
    private static final int UNCOMPRESSED_HEADER_LENGTH = 3;
    public static final int CRC24_LENGTH = 3;
    public static final int CRC32_LENGTH = 4;
    private final PrimitiveCodec<B> primitiveCodec;
    private final Compressor<B> compressor;
    private final boolean compress;

    public SegmentCodec(PrimitiveCodec<B> primitiveCodec, Compressor<B> compressor) {
        this.primitiveCodec = primitiveCodec;
        this.compressor = compressor;
        this.compress = !(compressor instanceof NoopCompressor);
    }

    public int headerLength() {
        return this.compress ? 5 : 3;
    }

    public void encode(Segment<B> segment, List<Object> out) {
        Object encodedPayload;
        Object uncompressedPayload = segment.payload;
        int uncompressedPayloadLength = this.primitiveCodec.sizeOf(uncompressedPayload);
        assert (uncompressedPayloadLength <= Segment.MAX_PAYLOAD_LENGTH);
        if (this.compress) {
            this.primitiveCodec.markReaderIndex(uncompressedPayload);
            B compressedPayload = this.compressor.compressWithoutLength(uncompressedPayload);
            if (this.primitiveCodec.sizeOf(compressedPayload) >= uncompressedPayloadLength) {
                this.primitiveCodec.resetReaderIndex(uncompressedPayload);
                encodedPayload = uncompressedPayload;
                this.primitiveCodec.release(compressedPayload);
                uncompressedPayloadLength = 0;
            } else {
                encodedPayload = compressedPayload;
                this.primitiveCodec.release(uncompressedPayload);
            }
        } else {
            encodedPayload = uncompressedPayload;
        }
        int payloadLength = this.primitiveCodec.sizeOf(encodedPayload);
        B header2 = this.encodeHeader(payloadLength, uncompressedPayloadLength, segment.isSelfContained);
        int payloadCrc = Crc.computeCrc32(encodedPayload, this.primitiveCodec);
        B trailer = this.primitiveCodec.allocate(4);
        for (int i = 0; i < 4; ++i) {
            this.primitiveCodec.writeByte((byte)(payloadCrc & 0xFF), trailer);
            payloadCrc >>= 8;
        }
        out.add(header2);
        out.add(encodedPayload);
        out.add(trailer);
    }

    B encodeHeader(int payloadLength, int uncompressedLength, boolean isSelfContained) {
        int shift;
        int i;
        assert (payloadLength <= Segment.MAX_PAYLOAD_LENGTH);
        int headerLength2 = this.headerLength();
        long headerData = payloadLength;
        int flagOffset = 17;
        if (this.compress) {
            headerData |= (long)uncompressedLength << 17;
            flagOffset += 17;
        }
        if (isSelfContained) {
            headerData |= 1L << flagOffset;
        }
        int headerCrc = Crc.computeCrc24(headerData, headerLength2);
        B header2 = this.primitiveCodec.allocate(headerLength2 + 3);
        for (i = 0; i < headerLength2; ++i) {
            shift = i * 8;
            this.primitiveCodec.writeByte((byte)(headerData >> shift & 0xFFL), header2);
        }
        for (i = 0; i < 3; ++i) {
            shift = i * 8;
            this.primitiveCodec.writeByte((byte)(headerCrc >> shift & 0xFF), header2);
        }
        return header2;
    }

    public Header decodeHeader(B source) throws CrcMismatchException {
        int uncompressedPayloadLength;
        int headerLength2 = this.headerLength();
        assert (this.primitiveCodec.sizeOf(source) >= headerLength2 + 3);
        long headerData = 0L;
        for (int i = 0; i < headerLength2; ++i) {
            headerData |= ((long)this.primitiveCodec.readByte(source) & 0xFFL) << 8 * i;
        }
        int expectedHeaderCrc = 0;
        for (int i = 0; i < 3; ++i) {
            expectedHeaderCrc |= (this.primitiveCodec.readByte(source) & 0xFF) << 8 * i;
        }
        int actualHeaderCrc = Crc.computeCrc24(headerData, headerLength2);
        if (actualHeaderCrc != expectedHeaderCrc) {
            throw new CrcMismatchException(String.format("CRC mismatch on header %s. Received %s, computed %s.", Long.toHexString(headerData), Integer.toHexString(expectedHeaderCrc), Integer.toHexString(actualHeaderCrc)));
        }
        int payloadLength = (int)headerData & Segment.MAX_PAYLOAD_LENGTH;
        headerData >>= 17;
        if (this.compress) {
            uncompressedPayloadLength = (int)headerData & Segment.MAX_PAYLOAD_LENGTH;
            headerData >>= 17;
        } else {
            uncompressedPayloadLength = -1;
        }
        boolean isSelfContained = (headerData & 1L) == 1L;
        return new Header(payloadLength, uncompressedPayloadLength, isSelfContained);
    }

    public Segment<B> decode(Header header2, B source) throws CrcMismatchException {
        B payload;
        assert (this.primitiveCodec.sizeOf(source) == header2.payloadLength + 4);
        B encodedPayload = this.primitiveCodec.readRetainedSlice(source, header2.payloadLength);
        int expectedPayloadCrc = 0;
        for (int i = 0; i < 4; ++i) {
            expectedPayloadCrc |= (this.primitiveCodec.readByte(source) & 0xFF) << 8 * i;
        }
        this.primitiveCodec.release(source);
        int actualPayloadCrc = Crc.computeCrc32(encodedPayload, this.primitiveCodec);
        if (actualPayloadCrc != expectedPayloadCrc) {
            this.primitiveCodec.release(encodedPayload);
            throw new CrcMismatchException(String.format("CRC mismatch on payload. Received %s, computed %s.", Integer.toHexString(expectedPayloadCrc), Integer.toHexString(actualPayloadCrc)));
        }
        if (this.compress && header2.uncompressedPayloadLength > 0) {
            payload = this.compressor.decompressWithoutLength(encodedPayload, header2.uncompressedPayloadLength);
            this.primitiveCodec.release(encodedPayload);
        } else {
            payload = encodedPayload;
        }
        return new Segment<B>(payload, header2.isSelfContained);
    }

    public static class Header {
        public final int payloadLength;
        public final int uncompressedPayloadLength;
        public final boolean isSelfContained;

        public Header(int payloadLength, int uncompressedPayloadLength, boolean isSelfContained) {
            this.payloadLength = payloadLength;
            this.uncompressedPayloadLength = uncompressedPayloadLength;
            this.isSelfContained = isSelfContained;
        }
    }
}

