/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class PrimitiveSizes {
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INT = 4;
    public static final int LONG = 8;
    public static final int UUID = 16;

    private PrimitiveSizes() {
    }

    public static int sizeOfString(String str) {
        return 2 + PrimitiveSizes.encodedUTF8Length(str);
    }

    public static int sizeOfLongString(String s2) {
        return 4 + PrimitiveSizes.encodedUTF8Length(s2);
    }

    public static int sizeOfStringList(List<String> l) {
        int size2 = 2;
        for (String str : l) {
            size2 += PrimitiveSizes.sizeOfString(str);
        }
        return size2;
    }

    public static int sizeOfBytes(byte[] bytes2) {
        return 4 + (bytes2 == null ? 0 : bytes2.length);
    }

    public static int sizeOfBytes(ByteBuffer bytes2) {
        return 4 + (bytes2 == null ? 0 : bytes2.remaining());
    }

    public static int sizeOfShortBytes(byte[] bytes2) {
        return 2 + bytes2.length;
    }

    public static int sizeOfShortBytes(ByteBuffer bytes2) {
        return 2 + (bytes2 == null ? 0 : bytes2.remaining());
    }

    public static int sizeOfStringMap(Map<String, String> m) {
        int size2 = 2;
        for (Map.Entry<String, String> entry2 : m.entrySet()) {
            size2 += PrimitiveSizes.sizeOfString(entry2.getKey());
            size2 += PrimitiveSizes.sizeOfString(entry2.getValue());
        }
        return size2;
    }

    public static int sizeOfStringMultimap(Map<String, List<String>> m) {
        int size2 = 2;
        for (Map.Entry<String, List<String>> entry2 : m.entrySet()) {
            size2 += PrimitiveSizes.sizeOfString(entry2.getKey());
            size2 += PrimitiveSizes.sizeOfStringList(entry2.getValue());
        }
        return size2;
    }

    public static int sizeOfBytesMap(Map<String, ByteBuffer> m) {
        int size2 = 2;
        for (Map.Entry<String, ByteBuffer> entry2 : m.entrySet()) {
            size2 += PrimitiveSizes.sizeOfString(entry2.getKey());
            size2 += PrimitiveSizes.sizeOfBytes(entry2.getValue());
        }
        return size2;
    }

    static int encodedUTF8Length(String st) {
        int length = 0;
        for (int i = 0; i < st.length(); ++i) {
            char c = st.charAt(i);
            if (Character.isHighSurrogate(c)) {
                char c1;
                if (i < st.length() - 1 && Character.isLowSurrogate(c1 = st.charAt(i + 1))) {
                    length += 4;
                    ++i;
                    continue;
                }
                ++length;
                continue;
            }
            if (Character.isLowSurrogate(c)) {
                ++length;
                continue;
            }
            if (c <= '\u007f') {
                ++length;
                continue;
            }
            if (c <= '\u07ff') {
                length += 2;
                continue;
            }
            length += 3;
        }
        return length;
    }

    public static int sizeOfInet(InetSocketAddress address) {
        return PrimitiveSizes.sizeOfInetAddr(address.getAddress()) + 4;
    }

    public static int sizeOfInetAddr(InetAddress address) {
        byte[] raw2 = address.getAddress();
        return 1 + raw2.length;
    }
}

