/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CRC32;

public interface PrimitiveCodec<B> {
    public B allocate(int var1);

    public void release(B var1);

    public int sizeOf(B var1);

    public B concat(B var1, B var2);

    public void markReaderIndex(B var1);

    public void resetReaderIndex(B var1);

    public byte readByte(B var1);

    public int readInt(B var1);

    public int readInt(B var1, int var2);

    public InetAddress readInetAddr(B var1);

    public long readLong(B var1);

    public int readUnsignedShort(B var1);

    public ByteBuffer readBytes(B var1);

    public byte[] readShortBytes(B var1);

    public String readString(B var1);

    public String readLongString(B var1);

    public B readRetainedSlice(B var1, int var2);

    public void updateCrc(B var1, CRC32 var2);

    default public UUID readUuid(B source) {
        long msb = this.readLong(source);
        long lsb = this.readLong(source);
        return new UUID(msb, lsb);
    }

    default public List<String> readStringList(B source) {
        int size2 = this.readUnsignedShort(source);
        if (size2 == 0) {
            return Collections.emptyList();
        }
        NullAllowingImmutableList.Builder<String> builder = NullAllowingImmutableList.builder(size2);
        for (int i = 0; i < size2; ++i) {
            builder.add(this.readString(source));
        }
        return builder.build();
    }

    default public Map<String, String> readStringMap(B source) {
        int size2 = this.readUnsignedShort(source);
        if (size2 == 0) {
            return Collections.emptyMap();
        }
        NullAllowingImmutableMap.Builder<String, String> builder = NullAllowingImmutableMap.builder(size2);
        for (int i = 0; i < size2; ++i) {
            String k = this.readString(source);
            String v = this.readString(source);
            builder.put(k, v);
        }
        return builder.build();
    }

    default public Map<String, List<String>> readStringMultimap(B source) {
        int size2 = this.readUnsignedShort(source);
        if (size2 == 0) {
            return Collections.emptyMap();
        }
        NullAllowingImmutableMap.Builder<String, List<String>> builder = NullAllowingImmutableMap.builder(size2);
        for (int i = 0; i < size2; ++i) {
            String key = this.readString(source);
            List<String> value2 = this.readStringList(source);
            builder.put(key, value2);
        }
        return builder.build();
    }

    default public Map<String, ByteBuffer> readBytesMap(B source) {
        int size2 = this.readUnsignedShort(source);
        if (size2 == 0) {
            return Collections.emptyMap();
        }
        NullAllowingImmutableMap.Builder<String, ByteBuffer> builder = NullAllowingImmutableMap.builder(size2);
        for (int i = 0; i < size2; ++i) {
            String key = this.readString(source);
            ByteBuffer value2 = this.readBytes(source);
            builder.put(key, value2);
        }
        return builder.build();
    }

    default public InetSocketAddress readInet(B source) {
        InetAddress addr = this.readInetAddr(source);
        int port = this.readInt(source);
        return new InetSocketAddress(addr, port);
    }

    public void writeByte(byte var1, B var2);

    public void writeInt(int var1, B var2);

    public void writeInetAddr(InetAddress var1, B var2);

    public void writeLong(long var1, B var3);

    public void writeUnsignedShort(int var1, B var2);

    public void writeString(String var1, B var2);

    public void writeLongString(String var1, B var2);

    default public void writeUuid(UUID uuid, B dest) {
        this.writeLong(uuid.getMostSignificantBits(), dest);
        this.writeLong(uuid.getLeastSignificantBits(), dest);
    }

    public void writeBytes(ByteBuffer var1, B var2);

    public void writeBytes(byte[] var1, B var2);

    public void writeShortBytes(byte[] var1, B var2);

    default public void writeStringList(List<String> l, B dest) {
        this.writeUnsignedShort(l.size(), dest);
        for (String s2 : l) {
            this.writeString(s2, dest);
        }
    }

    default public void writeStringMap(Map<String, String> m, B dest) {
        this.writeUnsignedShort(m.size(), dest);
        for (Map.Entry<String, String> entry2 : m.entrySet()) {
            this.writeString(entry2.getKey(), dest);
            this.writeString(entry2.getValue(), dest);
        }
    }

    default public void writeStringMultimap(Map<String, List<String>> m, B dest) {
        this.writeUnsignedShort(m.size(), dest);
        for (Map.Entry<String, List<String>> entry2 : m.entrySet()) {
            this.writeString(entry2.getKey(), dest);
            this.writeStringList(entry2.getValue(), dest);
        }
    }

    default public void writeBytesMap(Map<String, ByteBuffer> m, B dest) {
        this.writeUnsignedShort(m.size(), dest);
        for (Map.Entry<String, ByteBuffer> entry2 : m.entrySet()) {
            this.writeString(entry2.getKey(), dest);
            this.writeBytes(entry2.getValue(), dest);
        }
    }

    default public void writeInet(InetSocketAddress address, B dest) {
        this.writeInetAddr(address.getAddress(), dest);
        this.writeInt(address.getPort(), dest);
    }
}

