/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Frame {
    public static final Map<String, ByteBuffer> NO_PAYLOAD = Collections.emptyMap();
    public final int protocolVersion;
    public final boolean beta;
    public final int streamId;
    public final UUID tracingId;
    public final boolean tracing;
    public final int size;
    public final int compressedSize;
    public final Map<String, ByteBuffer> customPayload;
    public final List<String> warnings;
    public final Message message;

    public static Frame forRequest(int protocolVersion, int streamId, boolean tracing2, Map<String, ByteBuffer> customPayload, Message message) {
        return new Frame(protocolVersion, false, streamId, tracing2, null, -1, -1, customPayload, Collections.emptyList(), message);
    }

    public static Frame forResponse(int protocolVersion, int streamId, UUID tracingId, Map<String, ByteBuffer> customPayload, List<String> warnings, Message message) {
        return new Frame(protocolVersion, false, streamId, false, tracingId, -1, -1, customPayload, warnings, message);
    }

    public Frame(int protocolVersion, boolean beta, int streamId, boolean tracing2, UUID tracingId, int size2, int compressedSize, Map<String, ByteBuffer> customPayload, List<String> warnings, Message message) {
        ProtocolErrors.check(customPayload.isEmpty() || protocolVersion >= 4, "Custom payloads require protocol V4", new Object[0]);
        this.protocolVersion = protocolVersion;
        this.beta = beta;
        this.streamId = streamId;
        this.tracingId = tracingId;
        this.tracing = tracing2;
        this.size = size2;
        this.compressedSize = compressedSize;
        this.customPayload = customPayload;
        this.warnings = warnings;
        this.message = message;
    }

    @Deprecated
    public Frame(int protocolVersion, boolean beta, int streamId, boolean tracing2, UUID tracingId, Map<String, ByteBuffer> customPayload, List<String> warnings, Message message) {
        this(protocolVersion, beta, streamId, tracing2, tracingId, -1, -1, customPayload, warnings, message);
    }
}

