/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.guava.common.hash;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.hash.AbstractByteHasher;
import com.datastax.oss.driver.shaded.guava.common.hash.AbstractHashFunction;
import com.datastax.oss.driver.shaded.guava.common.hash.HashCode;
import com.datastax.oss.driver.shaded.guava.common.hash.Hasher;
import com.datastax.oss.driver.shaded.guava.common.hash.ImmutableSupplier;
import com.datastax.oss.driver.shaded.guava.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.zip.Checksum;

@Immutable
final class ChecksumHashFunction
extends AbstractHashFunction
implements Serializable {
    private final ImmutableSupplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(ImmutableSupplier<? extends Checksum> checksumSupplier, int bits2, String toString2) {
        this.checksumSupplier = Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument(bits2 == 32 || bits2 == 64, "bits (%s) must be either 32 or 64", bits2);
        this.bits = bits2;
        this.toString = Preconditions.checkNotNull(toString2);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher((Checksum)this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update(b);
        }

        @Override
        protected void update(byte[] bytes2, int off, int len) {
            this.checksum.update(bytes2, off, len);
        }

        @Override
        public HashCode hash() {
            long value2 = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCode.fromInt((int)value2);
            }
            return HashCode.fromLong(value2);
        }
    }
}

