/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.guava.common.graph;

import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.UnmodifiableIterator;
import com.datastax.oss.driver.shaded.guava.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    private transient @Nullable Map.Entry<K, V> entrySetCache;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CanIgnoreReturnValue
    public V put(@Nullable K key, @Nullable V value2) {
        this.clearCache();
        return this.backingMap.put(key, value2);
    }

    @CanIgnoreReturnValue
    public V remove(@Nullable Object key) {
        this.clearCache();
        return this.backingMap.remove(key);
    }

    public void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(@Nullable Object key) {
        V value2 = this.getIfCached(key);
        return value2 != null ? value2 : this.getWithoutCaching(key);
    }

    public final V getWithoutCaching(@Nullable Object key) {
        return this.backingMap.get(key);
    }

    public final boolean containsKey(@Nullable Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry2 = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.entrySetCache = entry2;
                        return entry2.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@Nullable Object key) {
                return MapIteratorCache.this.containsKey(key);
            }
        };
    }

    protected V getIfCached(@Nullable Object key) {
        Map.Entry<K, V> entry2 = this.entrySetCache;
        if (entry2 != null && entry2.getKey() == key) {
            return entry2.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.entrySetCache = null;
    }
}

