/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.guava.common.collect;

import com.datastax.oss.driver.shaded.guava.common.annotations.Beta;
import com.datastax.oss.driver.shaded.guava.common.annotations.GwtCompatible;
import com.datastax.oss.driver.shaded.guava.common.annotations.GwtIncompatible;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.base.Predicates;
import com.datastax.oss.driver.shaded.guava.common.collect.AbstractIndexedListIterator;
import com.datastax.oss.driver.shaded.guava.common.collect.AbstractIterator;
import com.datastax.oss.driver.shaded.guava.common.collect.BoundType;
import com.datastax.oss.driver.shaded.guava.common.collect.CartesianList;
import com.datastax.oss.driver.shaded.guava.common.collect.CollectPreconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.Collections2;
import com.datastax.oss.driver.shaded.guava.common.collect.ForwardingCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ForwardingNavigableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ForwardingSortedSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableEnumSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterators;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Multiset;
import com.datastax.oss.driver.shaded.guava.common.collect.Ordering;
import com.datastax.oss.driver.shaded.guava.common.collect.Range;
import com.datastax.oss.driver.shaded.guava.common.collect.Synchronized;
import com.datastax.oss.driver.shaded.guava.common.collect.UnmodifiableIterator;
import com.datastax.oss.driver.shaded.guava.common.math.IntMath;
import com.datastax.oss.driver.shaded.guava.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Sets {
    private Sets() {
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E anElement, E ... otherElements) {
        return ImmutableEnumSet.asImmutable(EnumSet.of(anElement, otherElements));
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> elements) {
        if (elements instanceof ImmutableEnumSet) {
            return (ImmutableEnumSet)elements;
        }
        if (elements instanceof Collection) {
            Collection collection2 = (Collection)elements;
            if (collection2.isEmpty()) {
                return ImmutableSet.of();
            }
            return ImmutableEnumSet.asImmutable(EnumSet.copyOf(collection2));
        }
        Iterator<E> itr = elements.iterator();
        if (itr.hasNext()) {
            EnumSet<Enum> enumSet = EnumSet.of((Enum)itr.next());
            Iterators.addAll(enumSet, itr);
            return ImmutableEnumSet.asImmutable(enumSet);
        }
        return ImmutableSet.of();
    }

    @Beta
    public static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return Accumulator.TO_IMMUTABLE_ENUM_SET;
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> elementType2) {
        EnumSet<E> set2 = EnumSet.noneOf(elementType2);
        Iterables.addAll(set2, iterable);
        return set2;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet<E> set2 = Sets.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set2, elements);
        return set2;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new HashSet<E>(Collections2.cast(elements)) : Sets.newHashSet(elements.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set2 = Sets.newHashSet();
        Iterators.addAll(set2, elements);
        return set2;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Maps.capacity(expectedSize));
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <E> Set<E> newConcurrentHashSet(Iterable<? extends E> elements) {
        Set<E> set2 = Sets.newConcurrentHashSet();
        Iterables.addAll(set2, elements);
        return set2;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new LinkedHashSet<E>(Collections2.cast(elements));
        }
        LinkedHashSet<E> set2 = Sets.newLinkedHashSet();
        Iterables.addAll(set2, elements);
        return set2;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(Maps.capacity(expectedSize));
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        TreeSet<E> set2 = Sets.newTreeSet();
        Iterables.addAll(set2, elements);
        return set2;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(Preconditions.checkNotNull(comparator));
    }

    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(Maps.newIdentityHashMap());
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet(Iterable<? extends E> elements) {
        Collection<? extends E> elementsCollection = elements instanceof Collection ? Collections2.cast(elements) : Lists.newArrayList(elements);
        return new CopyOnWriteArraySet<E>(elementsCollection);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection2) {
        if (collection2 instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection2);
        }
        Preconditions.checkArgument(!collection2.isEmpty(), "collection is empty; use the other version of this method");
        Class type = ((Enum)collection2.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection2, type);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection2, Class<E> type) {
        Preconditions.checkNotNull(collection2);
        return collection2 instanceof EnumSet ? EnumSet.complementOf((EnumSet)collection2) : Sets.makeComplementByHand(collection2, type);
    }

    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection2, Class<E> type) {
        EnumSet<E> result2 = EnumSet.allOf(type);
        result2.removeAll(collection2);
        return result2;
    }

    @Deprecated
    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map2) {
        return Collections.newSetFromMap(map2);
    }

    public static <E> SetView<E> union(final Set<? extends E> set1, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public int size() {
                int size2 = set1.size();
                for (Object e : set2) {
                    if (set1.contains(e)) continue;
                    ++size2;
                }
                return size2;
            }

            @Override
            public boolean isEmpty() {
                return set1.isEmpty() && set2.isEmpty();
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    {
                        this.itr1 = set1.iterator();
                        this.itr2 = set2.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        if (this.itr1.hasNext()) {
                            return this.itr1.next();
                        }
                        while (this.itr2.hasNext()) {
                            Object e = this.itr2.next();
                            if (set1.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return Stream.concat(set1.stream(), set2.stream().filter(e -> !set1.contains(e)));
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)this.stream().parallel();
            }

            @Override
            public boolean contains(Object object) {
                return set1.contains(object) || set2.contains(object);
            }

            @Override
            public <S extends Set<E>> S copyInto(S set22) {
                set22.addAll(set1);
                set22.addAll(set2);
                return set22;
            }

            @Override
            public ImmutableSet<E> immutableCopy() {
                return ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set1)).addAll((Iterable)set2)).build();
            }
        };
    }

    public static <E> SetView<E> intersection(final Set<E> set1, final Set<?> set2) {
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set1.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e = this.itr.next();
                            if (!set2.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set1.stream().filter(set2::contains);
            }

            @Override
            public Stream<E> parallelStream() {
                return set1.parallelStream().filter(set2::contains);
            }

            @Override
            public int size() {
                int size2 = 0;
                for (Object e : set1) {
                    if (!set2.contains(e)) continue;
                    ++size2;
                }
                return size2;
            }

            @Override
            public boolean isEmpty() {
                return Collections.disjoint(set1, set2);
            }

            @Override
            public boolean contains(Object object) {
                return set1.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection2) {
                return set1.containsAll(collection2) && set2.containsAll(collection2);
            }
        };
    }

    public static <E> SetView<E> difference(final Set<E> set1, final Set<?> set2) {
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set1.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e = this.itr.next();
                            if (set2.contains(e)) continue;
                            return e;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set1.stream().filter(e -> !set2.contains(e));
            }

            @Override
            public Stream<E> parallelStream() {
                return set1.parallelStream().filter(e -> !set2.contains(e));
            }

            @Override
            public int size() {
                int size2 = 0;
                for (Object e : set1) {
                    if (set2.contains(e)) continue;
                    ++size2;
                }
                return size2;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set1);
            }

            @Override
            public boolean contains(Object element) {
                return set1.contains(element) && !set2.contains(element);
            }
        };
    }

    public static <E> SetView<E> symmetricDifference(final Set<? extends E> set1, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set1, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                final Iterator itr1 = set1.iterator();
                final Iterator itr2 = set2.iterator();
                return new AbstractIterator<E>(){

                    @Override
                    public E computeNext() {
                        while (itr1.hasNext()) {
                            Object elem1 = itr1.next();
                            if (set2.contains(elem1)) continue;
                            return elem1;
                        }
                        while (itr2.hasNext()) {
                            Object elem2 = itr2.next();
                            if (set1.contains(elem2)) continue;
                            return elem2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                int size2 = 0;
                for (Object e : set1) {
                    if (set2.contains(e)) continue;
                    ++size2;
                }
                for (Object e : set2) {
                    if (set1.contains(e)) continue;
                    ++size2;
                }
                return size2;
            }

            @Override
            public boolean isEmpty() {
                return set1.equals(set2);
            }

            @Override
            public boolean contains(Object element) {
                return set1.contains(element) ^ set2.contains(element);
            }
        };
    }

    public static <E> Set<E> filter(Set<E> unfiltered, com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> predicate) {
        if (unfiltered instanceof SortedSet) {
            return Sets.filter((SortedSet)unfiltered, predicate);
        }
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered2 = (FilteredSet)unfiltered;
            com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> combinedPredicate = Predicates.and(filtered2.predicate, predicate);
            return new FilteredSet<E>((Set)filtered2.unfiltered, combinedPredicate);
        }
        return new FilteredSet<E>(Preconditions.checkNotNull(unfiltered), Preconditions.checkNotNull(predicate));
    }

    public static <E> SortedSet<E> filter(SortedSet<E> unfiltered, com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> predicate) {
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered2 = (FilteredSet)((Object)unfiltered);
            com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> combinedPredicate = Predicates.and(filtered2.predicate, predicate);
            return new FilteredSortedSet<E>((SortedSet)filtered2.unfiltered, combinedPredicate);
        }
        return new FilteredSortedSet<E>(Preconditions.checkNotNull(unfiltered), Preconditions.checkNotNull(predicate));
    }

    @GwtIncompatible
    public static <E> NavigableSet<E> filter(NavigableSet<E> unfiltered, com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> predicate) {
        if (unfiltered instanceof FilteredSet) {
            FilteredSet filtered2 = (FilteredSet)((Object)unfiltered);
            com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> combinedPredicate = Predicates.and(filtered2.predicate, predicate);
            return new FilteredNavigableSet<E>((NavigableSet)filtered2.unfiltered, combinedPredicate);
        }
        return new FilteredNavigableSet<E>(Preconditions.checkNotNull(unfiltered), Preconditions.checkNotNull(predicate));
    }

    public static <B> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> sets) {
        return CartesianSet.create(sets);
    }

    @SafeVarargs
    public static <B> Set<List<B>> cartesianProduct(Set<? extends B> ... sets) {
        return Sets.cartesianProduct(Arrays.asList(sets));
    }

    @GwtCompatible(serializable=false)
    public static <E> Set<Set<E>> powerSet(Set<E> set2) {
        return new PowerSet<E>(set2);
    }

    @Beta
    public static <E> Set<Set<E>> combinations(Set<E> set2, final int size2) {
        final ImmutableMap<E, Integer> index2 = Maps.indexMap(set2);
        CollectPreconditions.checkNonnegative(size2, "size");
        Preconditions.checkArgument(size2 <= index2.size(), "size (%s) must be <= set.size() (%s)", size2, index2.size());
        if (size2 == 0) {
            return ImmutableSet.of(ImmutableSet.of());
        }
        if (size2 == index2.size()) {
            return ImmutableSet.of(index2.keySet());
        }
        return new AbstractSet<Set<E>>(){

            @Override
            public boolean contains(@Nullable Object o) {
                if (o instanceof Set) {
                    Set s2 = (Set)o;
                    return s2.size() == size2 && ((AbstractCollection)((Object)index2.keySet())).containsAll(s2);
                }
                return false;
            }

            @Override
            public Iterator<Set<E>> iterator() {
                return new AbstractIterator<Set<E>>(){
                    final BitSet bits;
                    {
                        this.bits = new BitSet(index2.size());
                    }

                    @Override
                    protected Set<E> computeNext() {
                        if (this.bits.isEmpty()) {
                            this.bits.set(0, size2);
                        } else {
                            int firstSetBit = this.bits.nextSetBit(0);
                            int bitToFlip = this.bits.nextClearBit(firstSetBit);
                            if (bitToFlip == index2.size()) {
                                return (Set)this.endOfData();
                            }
                            this.bits.set(0, bitToFlip - firstSetBit - 1);
                            this.bits.clear(bitToFlip - firstSetBit - 1, bitToFlip);
                            this.bits.set(bitToFlip);
                        }
                        final BitSet copy = (BitSet)this.bits.clone();
                        return new AbstractSet<E>(){

                            @Override
                            public boolean contains(@Nullable Object o) {
                                Integer i = (Integer)index2.get(o);
                                return i != null && copy.get(i);
                            }

                            @Override
                            public Iterator<E> iterator() {
                                return new AbstractIterator<E>(){
                                    int i = -1;

                                    @Override
                                    protected E computeNext() {
                                        this.i = copy.nextSetBit(this.i + 1);
                                        if (this.i == -1) {
                                            return this.endOfData();
                                        }
                                        return ((ImmutableSet)index2.keySet()).asList().get(this.i);
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return size2;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return IntMath.binomial(index2.size(), size2);
            }

            @Override
            public String toString() {
                return "Sets.combinations(" + index2.keySet() + ", " + size2 + ")";
            }
        };
    }

    static int hashCodeImpl(Set<?> s2) {
        int hashCode = 0;
        for (Object o : s2) {
            hashCode += o != null ? o.hashCode() : 0;
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    static boolean equalsImpl(Set<?> s2, @Nullable Object object) {
        if (s2 == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o = (Set)object;
            try {
                return s2.size() == o.size() && s2.containsAll(o);
            }
            catch (ClassCastException | NullPointerException ignored) {
                return false;
            }
        }
        return false;
    }

    public static <E> NavigableSet<E> unmodifiableNavigableSet(NavigableSet<E> set2) {
        if (set2 instanceof ImmutableCollection || set2 instanceof UnmodifiableNavigableSet) {
            return set2;
        }
        return new UnmodifiableNavigableSet<E>(set2);
    }

    @GwtIncompatible
    public static <E> NavigableSet<E> synchronizedNavigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet);
    }

    static boolean removeAllImpl(Set<?> set2, Iterator<?> iterator2) {
        boolean changed = false;
        while (iterator2.hasNext()) {
            changed |= set2.remove(iterator2.next());
        }
        return changed;
    }

    static boolean removeAllImpl(Set<?> set2, Collection<?> collection2) {
        Preconditions.checkNotNull(collection2);
        if (collection2 instanceof Multiset) {
            collection2 = ((Multiset)collection2).elementSet();
        }
        if (collection2 instanceof Set && collection2.size() > set2.size()) {
            return Iterators.removeAll(set2.iterator(), collection2);
        }
        return Sets.removeAllImpl(set2, collection2.iterator());
    }

    @Beta
    @GwtIncompatible
    public static <K extends Comparable<? super K>> NavigableSet<K> subSet(NavigableSet<K> set2, Range<K> range2) {
        if (set2.comparator() != null && set2.comparator() != Ordering.natural() && range2.hasLowerBound() && range2.hasUpperBound()) {
            Preconditions.checkArgument(set2.comparator().compare(range2.lowerEndpoint(), range2.upperEndpoint()) <= 0, "set is using a custom comparator which is inconsistent with the natural ordering.");
        }
        if (range2.hasLowerBound() && range2.hasUpperBound()) {
            return set2.subSet(range2.lowerEndpoint(), range2.lowerBoundType() == BoundType.CLOSED, range2.upperEndpoint(), range2.upperBoundType() == BoundType.CLOSED);
        }
        if (range2.hasLowerBound()) {
            return set2.tailSet(range2.lowerEndpoint(), range2.lowerBoundType() == BoundType.CLOSED);
        }
        if (range2.hasUpperBound()) {
            return set2.headSet(range2.upperEndpoint(), range2.upperBoundType() == BoundType.CLOSED);
        }
        return Preconditions.checkNotNull(set2);
    }

    @GwtIncompatible
    static class DescendingSet<E>
    extends ForwardingNavigableSet<E> {
        private final NavigableSet<E> forward;

        DescendingSet(NavigableSet<E> forward) {
            this.forward = forward;
        }

        @Override
        protected NavigableSet<E> delegate() {
            return this.forward;
        }

        @Override
        public E lower(E e) {
            return this.forward.higher(e);
        }

        @Override
        public E floor(E e) {
            return this.forward.ceiling(e);
        }

        @Override
        public E ceiling(E e) {
            return this.forward.floor(e);
        }

        @Override
        public E higher(E e) {
            return this.forward.lower(e);
        }

        @Override
        public E pollFirst() {
            return this.forward.pollLast();
        }

        @Override
        public E pollLast() {
            return this.forward.pollFirst();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return this.forward;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.forward.iterator();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return this.forward.subSet(toElement, toInclusive, fromElement, fromInclusive).descendingSet();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.standardSubSet(fromElement, toElement);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive2) {
            return this.forward.tailSet(toElement, inclusive2).descendingSet();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.standardHeadSet(toElement);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive2) {
            return this.forward.headSet(fromElement, inclusive2).descendingSet();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.standardTailSet(fromElement);
        }

        @Override
        public Comparator<? super E> comparator() {
            Comparator forwardComparator = this.forward.comparator();
            if (forwardComparator == null) {
                return Ordering.natural().reverse();
            }
            return DescendingSet.reverse(forwardComparator);
        }

        private static <T> Ordering<T> reverse(Comparator<T> forward) {
            return Ordering.from(forward).reverse();
        }

        @Override
        public E first() {
            return this.forward.last();
        }

        @Override
        public E last() {
            return this.forward.first();
        }

        @Override
        public Iterator<E> iterator() {
            return this.forward.descendingIterator();
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array2) {
            return this.standardToArray(array2);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    static final class UnmodifiableNavigableSet<E>
    extends ForwardingSortedSet<E>
    implements NavigableSet<E>,
    Serializable {
        private final NavigableSet<E> delegate;
        private final SortedSet<E> unmodifiableDelegate;
        private transient @MonotonicNonNull UnmodifiableNavigableSet<E> descendingSet;
        private static final long serialVersionUID = 0L;

        UnmodifiableNavigableSet(NavigableSet<E> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.unmodifiableDelegate = Collections.unmodifiableSortedSet(delegate);
        }

        @Override
        protected SortedSet<E> delegate() {
            return this.unmodifiableDelegate;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<E> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> action2) {
            this.delegate.forEach(action2);
        }

        @Override
        public E lower(E e) {
            return this.delegate.lower(e);
        }

        @Override
        public E floor(E e) {
            return this.delegate.floor(e);
        }

        @Override
        public E ceiling(E e) {
            return this.delegate.ceiling(e);
        }

        @Override
        public E higher(E e) {
            return this.delegate.higher(e);
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            UnmodifiableNavigableSet<E> result2 = this.descendingSet;
            if (result2 == null) {
                result2 = this.descendingSet = new UnmodifiableNavigableSet<E>(this.delegate.descendingSet());
                result2.descendingSet = this;
            }
            return result2;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.unmodifiableIterator(this.delegate.descendingIterator());
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return Sets.unmodifiableNavigableSet(this.delegate.subSet(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive2) {
            return Sets.unmodifiableNavigableSet(this.delegate.headSet(toElement, inclusive2));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive2) {
            return Sets.unmodifiableNavigableSet(this.delegate.tailSet(fromElement, inclusive2));
        }
    }

    private static final class PowerSet<E>
    extends AbstractSet<Set<E>> {
        final ImmutableMap<E, Integer> inputSet;

        PowerSet(Set<E> input2) {
            this.inputSet = Maps.indexMap(input2);
            Preconditions.checkArgument(this.inputSet.size() <= 30, "Too many elements to create power set: %s > 30", this.inputSet.size());
        }

        @Override
        public int size() {
            return 1 << this.inputSet.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new AbstractIndexedListIterator<Set<E>>(this.size()){

                @Override
                protected Set<E> get(int setBits) {
                    return new SubSet(inputSet, setBits);
                }
            };
        }

        @Override
        public boolean contains(@Nullable Object obj) {
            if (obj instanceof Set) {
                Set set2 = (Set)obj;
                return ((AbstractCollection)((Object)this.inputSet.keySet())).containsAll(set2);
            }
            return false;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof PowerSet) {
                PowerSet that = (PowerSet)obj;
                return this.inputSet.equals(that.inputSet);
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return ((ImmutableSet)this.inputSet.keySet()).hashCode() << this.inputSet.size() - 1;
        }

        @Override
        public String toString() {
            return "powerSet(" + this.inputSet + ")";
        }
    }

    private static final class SubSet<E>
    extends AbstractSet<E> {
        private final ImmutableMap<E, Integer> inputSet;
        private final int mask;

        SubSet(ImmutableMap<E, Integer> inputSet, int mask) {
            this.inputSet = inputSet;
            this.mask = mask;
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                final ImmutableList<E> elements;
                int remainingSetBits;
                {
                    this.elements = ((ImmutableSet)inputSet.keySet()).asList();
                    this.remainingSetBits = mask;
                }

                @Override
                public boolean hasNext() {
                    return this.remainingSetBits != 0;
                }

                @Override
                public E next() {
                    int index2 = Integer.numberOfTrailingZeros(this.remainingSetBits);
                    if (index2 == 32) {
                        throw new NoSuchElementException();
                    }
                    this.remainingSetBits &= ~(1 << index2);
                    return this.elements.get(index2);
                }
            };
        }

        @Override
        public int size() {
            return Integer.bitCount(this.mask);
        }

        @Override
        public boolean contains(@Nullable Object o) {
            Integer index2 = this.inputSet.get(o);
            return index2 != null && (this.mask & 1 << index2) != 0;
        }
    }

    private static final class CartesianSet<E>
    extends ForwardingCollection<List<E>>
    implements Set<List<E>> {
        private final transient ImmutableList<ImmutableSet<E>> axes;
        private final transient CartesianList<E> delegate;

        static <E> Set<List<E>> create(List<? extends Set<? extends E>> sets) {
            ImmutableList.Builder axesBuilder = new ImmutableList.Builder(sets.size());
            for (Set<E> set2 : sets) {
                ImmutableSet<E> copy = ImmutableSet.copyOf(set2);
                if (copy.isEmpty()) {
                    return ImmutableSet.of();
                }
                axesBuilder.add(copy);
            }
            ImmutableCollection axes = axesBuilder.build();
            ImmutableList immutableList = new ImmutableList<List<E>>((ImmutableList)axes){
                final /* synthetic */ ImmutableList val$axes;
                {
                    this.val$axes = immutableList;
                }

                @Override
                public int size() {
                    return this.val$axes.size();
                }

                @Override
                public List<E> get(int index2) {
                    return ((ImmutableSet)this.val$axes.get(index2)).asList();
                }

                @Override
                boolean isPartialView() {
                    return true;
                }
            };
            return new CartesianSet(axes, new CartesianList(immutableList));
        }

        private CartesianSet(ImmutableList<ImmutableSet<E>> axes, CartesianList<E> delegate) {
            this.axes = axes;
            this.delegate = delegate;
        }

        @Override
        protected Collection<List<E>> delegate() {
            return this.delegate;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof CartesianSet) {
                CartesianSet that = (CartesianSet)object;
                return this.axes.equals(that.axes);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int adjust = this.size() - 1;
            for (int i = 0; i < this.axes.size(); ++i) {
                adjust *= 31;
                adjust = ~(~adjust);
            }
            int hash2 = 1;
            for (Set set2 : this.axes) {
                hash2 = 31 * hash2 + this.size() / set2.size() * set2.hashCode();
                hash2 = ~(~hash2);
            }
            return ~(~(hash2 += adjust));
        }
    }

    @GwtIncompatible
    private static class FilteredNavigableSet<E>
    extends FilteredSortedSet<E>
    implements NavigableSet<E> {
        FilteredNavigableSet(NavigableSet<E> unfiltered, com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> predicate) {
            super(unfiltered, predicate);
        }

        NavigableSet<E> unfiltered() {
            return (NavigableSet)this.unfiltered;
        }

        @Override
        public @Nullable E lower(E e) {
            return Iterators.find(this.unfiltered().headSet(e, false).descendingIterator(), this.predicate, null);
        }

        @Override
        public @Nullable E floor(E e) {
            return Iterators.find(this.unfiltered().headSet(e, true).descendingIterator(), this.predicate, null);
        }

        @Override
        public E ceiling(E e) {
            return Iterables.find(this.unfiltered().tailSet(e, true), this.predicate, null);
        }

        @Override
        public E higher(E e) {
            return Iterables.find(this.unfiltered().tailSet(e, false), this.predicate, null);
        }

        @Override
        public E pollFirst() {
            return Iterables.removeFirstMatching(this.unfiltered(), this.predicate);
        }

        @Override
        public E pollLast() {
            return Iterables.removeFirstMatching(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return Sets.filter(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.filter(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        public E last() {
            return Iterators.find(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return Sets.filter(this.unfiltered().subSet(fromElement, fromInclusive, toElement, toInclusive), this.predicate);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive2) {
            return Sets.filter(this.unfiltered().headSet(toElement, inclusive2), this.predicate);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive2) {
            return Sets.filter(this.unfiltered().tailSet(fromElement, inclusive2), this.predicate);
        }
    }

    private static class FilteredSortedSet<E>
    extends FilteredSet<E>
    implements SortedSet<E> {
        FilteredSortedSet(SortedSet<E> unfiltered, com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> predicate) {
            super(unfiltered, predicate);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.unfiltered).comparator();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).subSet(fromElement, toElement), this.predicate);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).headSet(toElement), this.predicate);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).tailSet(fromElement), this.predicate);
        }

        @Override
        public E first() {
            return Iterators.find(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public E last() {
            SortedSet sortedUnfiltered = (SortedSet)this.unfiltered;
            Object element;
            while (!this.predicate.apply(element = sortedUnfiltered.last())) {
                sortedUnfiltered = sortedUnfiltered.headSet(element);
            }
            return element;
        }
    }

    private static class FilteredSet<E>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        FilteredSet(Set<E> unfiltered, com.datastax.oss.driver.shaded.guava.common.base.Predicate<? super E> predicate) {
            super(unfiltered, predicate);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        @CanIgnoreReturnValue
        public <S extends Set<E>> S copyInto(S set2) {
            set2.addAll(this);
            return set2;
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean addAll(Collection<? extends E> newElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean removeAll(Collection<?> oldElements) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean removeIf(Predicate<? super E> filter2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean retainAll(Collection<?> elementsToKeep) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract UnmodifiableIterator<E> iterator();
    }

    private static final class Accumulator<E extends Enum<E>> {
        static final Collector<Enum<?>, ?, ImmutableSet<? extends Enum<?>>> TO_IMMUTABLE_ENUM_SET = Collector.of(Accumulator::new, Accumulator::add, Accumulator::combine, Accumulator::toImmutableSet, Collector.Characteristics.UNORDERED);
        private @MonotonicNonNull EnumSet<E> set;

        private Accumulator() {
        }

        void add(E e) {
            if (this.set == null) {
                this.set = EnumSet.of(e);
            } else {
                this.set.add(e);
            }
        }

        Accumulator<E> combine(Accumulator<E> other) {
            if (this.set == null) {
                return other;
            }
            if (other.set == null) {
                return this;
            }
            this.set.addAll(other.set);
            return this;
        }

        ImmutableSet<E> toImmutableSet() {
            return this.set == null ? ImmutableSet.of() : ImmutableEnumSet.asImmutable(this.set);
        }
    }

    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return Sets.removeAllImpl(this, c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return super.retainAll(Preconditions.checkNotNull(c));
        }
    }
}

