/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.guava.common.collect;

import com.datastax.oss.driver.shaded.guava.common.annotations.GwtCompatible;
import com.datastax.oss.driver.shaded.guava.common.annotations.GwtIncompatible;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.CollectPreconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.Hashing;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMapEntry;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMapEntrySet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.IndexedImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.JdkBackedImmutableMap;
import com.datastax.oss.driver.shaded.guava.errorprone.annotations.CanIgnoreReturnValue;
import com.datastax.oss.driver.shaded.guava.j2objc.annotations.Weak;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        return RegularImmutableMap.fromEntryArray(entries.length, entries);
    }

    static <K, V> ImmutableMap<K, V> fromEntryArray(int n, Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n, entryArray.length);
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        Map.Entry<K, V>[] entries = n == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n);
        int tableSize = Hashing.closedTableSize(n, 1.2);
        ImmutableMapEntry<K, V>[] table2 = ImmutableMapEntry.createEntryArray(tableSize);
        int mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < n; ++entryIndex) {
            Map.Entry<K, V> entry2 = entryArray[entryIndex];
            K key = entry2.getKey();
            V value2 = entry2.getValue();
            CollectPreconditions.checkEntryNotNull(key, value2);
            int tableIndex = Hashing.smear(key.hashCode()) & mask;
            ImmutableMapEntry existing = table2[tableIndex];
            ImmutableMapEntry newEntry = existing == null ? RegularImmutableMap.makeImmutable(entry2, key, value2) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(key, value2, existing);
            table2[tableIndex] = newEntry;
            entries[entryIndex] = newEntry;
            int bucketSize = RegularImmutableMap.checkNoConflictInKeyBucket(key, newEntry, existing);
            if (bucketSize <= 8) continue;
            return JdkBackedImmutableMap.create(n, entryArray);
        }
        return new RegularImmutableMap<K, V>(entries, table2, mask);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry2, K key, V value2) {
        boolean reusable = entry2 instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry2).isReusable();
        return reusable ? (ImmutableMapEntry)entry2 : new ImmutableMapEntry<K, V>(key, value2);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry2) {
        return RegularImmutableMap.makeImmutable(entry2, entry2.getKey(), entry2.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entries, ImmutableMapEntry<K, V>[] table2, int mask) {
        this.entries = entries;
        this.table = table2;
        this.mask = mask;
    }

    @CanIgnoreReturnValue
    static int checkNoConflictInKeyBucket(Object key, Map.Entry<?, ?> entry2, @Nullable ImmutableMapEntry<?, ?> keyBucketHead) {
        int bucketSize = 0;
        while (keyBucketHead != null) {
            RegularImmutableMap.checkNoConflict(!key.equals(keyBucketHead.getKey()), "key", entry2, keyBucketHead);
            ++bucketSize;
            keyBucketHead = keyBucketHead.getNextInKeyBucket();
        }
        return bucketSize;
    }

    @Override
    public V get(@Nullable Object key) {
        return RegularImmutableMap.get(key, this.table, this.mask);
    }

    static <V> @Nullable V get(@Nullable Object key, ImmutableMapEntry<?, V> @Nullable [] keyTable, int mask) {
        if (key == null || keyTable == null) {
            return null;
        }
        int index2 = Hashing.smear(key.hashCode()) & mask;
        for (ImmutableMapEntry<?, V> entry2 = keyTable[index2]; entry2 != null; entry2 = entry2.getNextInKeyBucket()) {
            Object candidateKey = entry2.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry2.getValue();
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        Preconditions.checkNotNull(action2);
        for (Map.Entry<K, V> entry2 : this.entries) {
            action2.accept(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K, V>
    extends ImmutableList<V> {
        @Weak
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> map2) {
            this.map = map2;
        }

        @Override
        public V get(int index2) {
            return this.map.entries[index2].getValue();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new SerializedForm<V>(this.map);
        }

        @GwtIncompatible
        private static class SerializedForm<V>
        implements Serializable {
            final ImmutableMap<?, V> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<?, V> map2) {
                this.map = map2;
            }

            Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K, V>
    extends IndexedImmutableSet<K> {
        @Weak
        private final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> map2) {
            this.map = map2;
        }

        @Override
        K get(int index2) {
            return this.map.entries[index2].getKey();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new SerializedForm<K>(this.map);
        }

        @GwtIncompatible
        private static class SerializedForm<K>
        implements Serializable {
            final ImmutableMap<K, ?> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<K, ?> map2) {
                this.map = map2;
            }

            Object readResolve() {
                return this.map.keySet();
            }
        }
    }
}

