/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.guava.common.collect;

import com.datastax.oss.driver.shaded.guava.common.annotations.GwtCompatible;
import com.datastax.oss.driver.shaded.guava.common.annotations.GwtIncompatible;
import com.datastax.oss.driver.shaded.guava.common.collect.CollectSpliterators;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import com.datastax.oss.driver.shaded.guava.common.collect.RegularImmutableAsList;
import com.datastax.oss.driver.shaded.guava.common.collect.RegularImmutableSortedSet;
import com.datastax.oss.driver.shaded.guava.common.collect.SortedIterable;
import java.util.Comparator;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableSortedAsList<E>
extends RegularImmutableAsList<E>
implements SortedIterable<E> {
    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        super(backingSet, backingList);
    }

    @Override
    ImmutableSortedSet<E> delegateCollection() {
        return (ImmutableSortedSet)super.delegateCollection();
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.delegateCollection()).comparator();
    }

    @Override
    @GwtIncompatible
    public int indexOf(@Nullable Object target) {
        int index2 = ((ImmutableSortedSet)this.delegateCollection()).indexOf(target);
        return index2 >= 0 && this.get(index2).equals(target) ? index2 : -1;
    }

    @Override
    @GwtIncompatible
    public int lastIndexOf(@Nullable Object target) {
        return this.indexOf(target);
    }

    @Override
    public boolean contains(Object target) {
        return this.indexOf(target) >= 0;
    }

    @Override
    @GwtIncompatible
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        ImmutableList parentSubList = super.subListUnchecked(fromIndex, toIndex);
        return new RegularImmutableSortedSet(parentSubList, this.comparator()).asList();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1301, this.delegateList()::get, this.comparator());
    }
}

