/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.ThreadFactory;

public class BlockingOperation {
    public static void checkNotDriverThread() {
        if (Thread.currentThread() instanceof InternalThread) {
            throw new IllegalStateException("Detected a synchronous API call on a driver thread, failing because this can cause deadlocks.");
        }
    }

    private static class InternalThread
    extends FastThreadLocalThread {
        private InternalThread(Runnable runnable) {
            super(runnable);
        }
    }

    public static class SafeThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(@NonNull Runnable r) {
            return new InternalThread(r);
        }
    }
}

