/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;

public class Strings {
    private static final ImmutableSet<String> RESERVED_KEYWORDS = ImmutableSet.of("add", "allow", "alter", "and", "apply", "asc", new String[]{"authorize", "batch", "begin", "by", "columnfamily", "create", "default", "delete", "desc", "describe", "drop", "entries", "execute", "from", "full", "grant", "if", "in", "index", "infinity", "insert", "into", "is", "keyspace", "limit", "materialized", "mbean", "mbeans", "modify", "nan", "norecursive", "not", "null", "of", "on", "or", "order", "primary", "rename", "replace", "revoke", "schema", "select", "set", "table", "to", "token", "truncate", "unlogged", "unset", "update", "use", "using", "view", "where", "with"});

    public static boolean isQuoted(String value2) {
        return Strings.isQuoted(value2, '\'');
    }

    public static String quote(String value2) {
        return Strings.quote(value2, '\'');
    }

    public static String unquote(String value2) {
        return Strings.unquote(value2, '\'');
    }

    public static boolean isDoubleQuoted(String value2) {
        return Strings.isQuoted(value2, '\"');
    }

    public static String doubleQuote(String value2) {
        return Strings.quote(value2, '\"');
    }

    public static String unDoubleQuote(String value2) {
        return Strings.unquote(value2, '\"');
    }

    public static boolean needsDoubleQuotes(String s2) {
        assert (s2 != null && !s2.isEmpty());
        char c = s2.charAt(0);
        if (c < 'a' || c > 'z') {
            return true;
        }
        for (int i = 1; i < s2.length(); ++i) {
            c = s2.charAt(i);
            if (c >= '0' && c <= '9' || c == '_' || c >= 'a' && c <= 'z') continue;
            return true;
        }
        return Strings.isReservedCqlKeyword(s2);
    }

    private static boolean isQuoted(String value2, char quoteChar) {
        return value2 != null && value2.length() > 1 && value2.charAt(0) == quoteChar && value2.charAt(value2.length() - 1) == quoteChar;
    }

    private static String emptyQuoted(char quoteChar) {
        assert (quoteChar == '\"' || quoteChar == '\'');
        if (quoteChar == '\"') {
            return "\"\"";
        }
        return "''";
    }

    private static String quote(String text2, char quoteChar) {
        if (text2 == null || text2.isEmpty()) {
            return Strings.emptyQuoted(quoteChar);
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text2.indexOf(quoteChar, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return quoteChar + text2 + quoteChar;
        }
        int newLength = 2 + text2.length() + nbMatch;
        char[] result2 = new char[newLength];
        result2[0] = quoteChar;
        result2[newLength - 1] = quoteChar;
        int newIdx = 1;
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == quoteChar) {
                result2[newIdx++] = c;
                result2[newIdx++] = c;
                continue;
            }
            result2[newIdx++] = c;
        }
        return new String(result2);
    }

    private static String unquote(String text2, char quoteChar) {
        if (!Strings.isQuoted(text2, quoteChar)) {
            return text2;
        }
        if (text2.length() == 2) {
            return "";
        }
        String search2 = Strings.emptyQuoted(quoteChar);
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text2.indexOf(search2, start + 2)) == -1 || start == text2.length() - 2) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return text2.substring(1, text2.length() - 1);
        }
        int newLength = text2.length() - nbMatch - 2;
        char[] result2 = new char[newLength];
        int newIdx = 0;
        boolean firstFound = false;
        for (int i = 1; i < text2.length() - 1; ++i) {
            char c = text2.charAt(i);
            if (c == quoteChar) {
                if (firstFound) {
                    firstFound = false;
                    continue;
                }
                firstFound = true;
                result2[newIdx++] = c;
                continue;
            }
            result2[newIdx++] = c;
            firstFound = false;
        }
        return new String(result2);
    }

    private static boolean isReservedCqlKeyword(String id) {
        return id != null && RESERVED_KEYWORDS.contains(id.toLowerCase());
    }

    public static boolean isLongLiteral(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ((c >= '0' || i == 0 && c == '-') && c <= '9') continue;
            return false;
        }
        return true;
    }

    private Strings() {
    }
}

