/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.data.ValuesHelper;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.request.query.Values;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Sizes {
    public static int minimumRequestSize(Request request) {
        int size2 = 9;
        if (!request.getCustomPayload().isEmpty()) {
            size2 += PrimitiveSizes.sizeOfBytesMap(request.getCustomPayload());
        }
        return size2;
    }

    public static int minimumStatementSize(Statement statement2, DriverContext context) {
        int size2 = Sizes.minimumRequestSize(statement2);
        size2 += QueryOptions.queryFlagsSize(context.getProtocolVersion().getCode());
        size2 += 2;
        return size2 += 2;
    }

    public static int sizeOfSimpleStatementValues(SimpleStatement simpleStatement, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size2 = 0;
        if (!simpleStatement.getPositionalValues().isEmpty()) {
            ArrayList<ByteBuffer> positionalValues = new ArrayList<ByteBuffer>(simpleStatement.getPositionalValues().size());
            for (Object value2 : simpleStatement.getPositionalValues()) {
                positionalValues.add(ValuesHelper.encodeToDefaultCqlMapping(value2, codecRegistry, protocolVersion));
            }
            size2 += Values.sizeOfPositionalValues(positionalValues);
        } else if (!simpleStatement.getNamedValues().isEmpty()) {
            HashMap<String, ByteBuffer> namedValues = new HashMap<String, ByteBuffer>(simpleStatement.getNamedValues().size());
            for (Map.Entry<CqlIdentifier, Object> value3 : simpleStatement.getNamedValues().entrySet()) {
                namedValues.put(value3.getKey().asInternal(), ValuesHelper.encodeToDefaultCqlMapping(value3.getValue(), codecRegistry, protocolVersion));
            }
            size2 += Values.sizeOfNamedValues(namedValues);
        }
        return size2;
    }

    public static int sizeOfBoundStatementValues(BoundStatement boundStatement) {
        return Values.sizeOfPositionalValues(boundStatement.getValues());
    }

    public static Integer sizeOfInnerBatchStatementInBytes(BatchableStatement statement2, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size2 = 0;
        ++size2;
        if (statement2 instanceof SimpleStatement) {
            size2 += PrimitiveSizes.sizeOfLongString(((SimpleStatement)statement2).getQuery());
            size2 += Sizes.sizeOfSimpleStatementValues((SimpleStatement)statement2, protocolVersion, codecRegistry);
        } else if (statement2 instanceof BoundStatement) {
            size2 += PrimitiveSizes.sizeOfShortBytes(((BoundStatement)statement2).getPreparedStatement().getId());
            size2 += Sizes.sizeOfBoundStatementValues((BoundStatement)statement2);
        }
        return size2;
    }
}

