/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import com.datastax.oss.driver.shaded.guava.common.collect.MultimapBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reflection {
    private static final Logger LOG = LoggerFactory.getLogger(Reflection.class);

    @Nullable
    public static Class<?> loadClass(@Nullable ClassLoader classLoader, @NonNull String className2) {
        try {
            Class<?> clazz2;
            if (classLoader == null) {
                LOG.trace("Attempting to load {} with driver's class loader", (Object)className2);
                clazz2 = Class.forName(className2);
            } else {
                LOG.trace("Attempting to load {} with {}", (Object)className2, (Object)classLoader);
                clazz2 = Class.forName(className2, true, classLoader);
            }
            LOG.trace("Successfully loaded {}", (Object)className2);
            return clazz2;
        }
        catch (Exception | LinkageError e) {
            LOG.debug(String.format("Could not load %s with loader %s: %s", className2, classLoader, e), e);
            if (classLoader == null) {
                return null;
            }
            return Reflection.loadClass(null, className2);
        }
    }

    public static <ComponentT> Optional<ComponentT> buildFromConfig(InternalDriverContext context, DriverOption classNameOption, Class<ComponentT> expectedSuperType, String ... defaultPackages) {
        return Reflection.buildFromConfig(context, null, classNameOption, expectedSuperType, defaultPackages);
    }

    public static <ComponentT> Map<String, ComponentT> buildFromConfigProfiles(InternalDriverContext context, DriverOption classNameOption, DriverOption rootOption, Class<ComponentT> expectedSuperType, String ... defaultPackages) {
        Multimap profilesByConfig = MultimapBuilder.hashKeys().arrayListValues().build();
        for (DriverExecutionProfile driverExecutionProfile : context.getConfig().getProfiles().values()) {
            profilesByConfig.put(driverExecutionProfile.getComparisonKey(rootOption), driverExecutionProfile.getName());
        }
        ImmutableMap.Builder<String, ComponentT> result2 = ImmutableMap.builder();
        for (Collection profiles : profilesByConfig.asMap().values()) {
            String profileName = (String)profiles.iterator().next();
            ComponentT policy = Reflection.buildFromConfig(context, profileName, classNameOption, expectedSuperType, defaultPackages).orElseThrow(() -> new IllegalArgumentException(String.format("Missing configuration for %s in profile %s", rootOption.getPath(), profileName)));
            for (String profile : profiles) {
                result2.put(profile, policy);
            }
        }
        return result2.build();
    }

    public static <ComponentT> Optional<ComponentT> buildFromConfig(InternalDriverContext context, String profileName, DriverOption classNameOption, Class<ComponentT> expectedSuperType, String ... defaultPackages) {
        Constructor<ComponentT> constructor;
        Object[] objectArray;
        DriverExecutionProfile config = profileName == null ? context.getConfig().getDefaultProfile() : context.getConfig().getProfile(profileName);
        String configPath = classNameOption.getPath();
        LOG.debug("Creating a {} from config option {}", (Object)expectedSuperType.getSimpleName(), (Object)configPath);
        if (!config.isDefined(classNameOption)) {
            LOG.debug("Option is not defined, skipping");
            return Optional.empty();
        }
        String className2 = config.getString(classNameOption);
        Class<?> clazz2 = null;
        if (className2.contains(".")) {
            LOG.debug("Building from fully-qualified name {}", (Object)className2);
            clazz2 = Reflection.loadClass(context.getClassLoader(), className2);
        } else {
            LOG.debug("Building from unqualified name {}", (Object)className2);
            for (String defaultPackage : defaultPackages) {
                String qualifiedClassName = defaultPackage + "." + className2;
                LOG.debug("Trying with default package {}", (Object)qualifiedClassName);
                clazz2 = Reflection.loadClass(context.getClassLoader(), qualifiedClassName);
                if (clazz2 != null) break;
            }
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException(String.format("Can't find class %s (specified by %s)", className2, configPath));
        }
        Preconditions.checkArgument(expectedSuperType.isAssignableFrom(clazz2), "Expected class %s (specified by %s) to be a subtype of %s", (Object)className2, (Object)configPath, (Object)expectedSuperType.getName());
        if (profileName == null) {
            Object[] objectArray2 = new Class[1];
            objectArray = objectArray2;
            objectArray2[0] = DriverContext.class;
        } else {
            Class[] classArray = new Class[2];
            classArray[0] = DriverContext.class;
            objectArray = classArray;
            classArray[1] = String.class;
        }
        Object[] argumentTypes = objectArray;
        try {
            constructor = clazz2.asSubclass(expectedSuperType).getConstructor((Class<?>[])argumentTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Expected class %s (specified by %s) to have an accessible constructor with arguments (%s)", className2, configPath, Joiner.on(',').join(argumentTypes)));
        }
        try {
            ComponentT instance = profileName == null ? constructor.newInstance(context) : constructor.newInstance(context, profileName);
            return Optional.of(instance);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            throw new IllegalArgumentException(String.format("Error instantiating class %s (specified by %s): %s", className2, configPath, cause.getMessage()), cause);
        }
    }
}

