/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

public class ProtocolUtils {
    public static String opcodeString(int opcode) {
        switch (opcode) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "STARTUP";
            }
            case 2: {
                return "READY";
            }
            case 3: {
                return "AUTHENTICATE";
            }
            case 5: {
                return "OPTIONS";
            }
            case 6: {
                return "SUPPORTED";
            }
            case 7: {
                return "QUERY";
            }
            case 8: {
                return "RESULT";
            }
            case 9: {
                return "PREPARE";
            }
            case 10: {
                return "EXECUTE";
            }
            case 11: {
                return "REGISTER";
            }
            case 12: {
                return "EVENT";
            }
            case 13: {
                return "BATCH";
            }
            case 14: {
                return "AUTH_CHALLENGE";
            }
            case 15: {
                return "AUTH_RESPONSE";
            }
            case 16: {
                return "AUTH_SUCCESS";
            }
        }
        return "0x" + Integer.toHexString(opcode);
    }

    public static String errorCodeString(int errorCode2) {
        switch (errorCode2) {
            case 0: {
                return "SERVER_ERROR";
            }
            case 10: {
                return "PROTOCOL_ERROR";
            }
            case 256: {
                return "AUTH_ERROR";
            }
            case 4096: {
                return "UNAVAILABLE";
            }
            case 4097: {
                return "OVERLOADED";
            }
            case 4098: {
                return "IS_BOOTSTRAPPING";
            }
            case 4099: {
                return "TRUNCATE_ERROR";
            }
            case 4352: {
                return "WRITE_TIMEOUT";
            }
            case 4608: {
                return "READ_TIMEOUT";
            }
            case 4864: {
                return "READ_FAILURE";
            }
            case 5120: {
                return "FUNCTION_FAILURE";
            }
            case 5376: {
                return "WRITE_FAILURE";
            }
            case 8192: {
                return "SYNTAX_ERROR";
            }
            case 8448: {
                return "UNAUTHORIZED";
            }
            case 8704: {
                return "INVALID";
            }
            case 8960: {
                return "CONFIG_ERROR";
            }
            case 9216: {
                return "ALREADY_EXISTS";
            }
            case 9472: {
                return "UNPREPARED";
            }
        }
        return "0x" + Integer.toHexString(errorCode2);
    }
}

