/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.LinkedHashMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DirectedGraph<VertexT> {
    private final Map<VertexT, Integer> vertices;
    private final Multimap<VertexT, VertexT> adjacencyList;
    private boolean wasSorted;

    public DirectedGraph(Collection<VertexT> vertices) {
        this.vertices = Maps.newLinkedHashMapWithExpectedSize(vertices.size());
        this.adjacencyList = LinkedHashMultimap.create();
        for (VertexT vertex : vertices) {
            this.vertices.put(vertex, 0);
        }
    }

    @SafeVarargs
    @VisibleForTesting
    DirectedGraph(VertexT ... vertices) {
        this((Collection<VertexT>)Arrays.asList(vertices));
    }

    public void addEdge(VertexT from2, VertexT to2) {
        Preconditions.checkArgument(this.vertices.containsKey(from2) && this.vertices.containsKey(to2));
        this.adjacencyList.put(from2, to2);
        this.vertices.put(to2, this.vertices.get(to2) + 1);
    }

    public List<VertexT> topologicalSort() {
        Preconditions.checkState(!this.wasSorted);
        this.wasSorted = true;
        ArrayDeque<VertexT> queue = new ArrayDeque<VertexT>();
        for (Map.Entry<VertexT, Integer> entry2 : this.vertices.entrySet()) {
            if (entry2.getValue() != 0) continue;
            queue.add(entry2.getKey());
        }
        ArrayList result2 = Lists.newArrayList();
        while (!queue.isEmpty()) {
            Object vertex = queue.remove();
            result2.add(vertex);
            for (VertexT successor : this.adjacencyList.get(vertex)) {
                if (this.decrementAndGetCount(successor) != 0) continue;
                queue.add(successor);
            }
        }
        if (result2.size() != this.vertices.size()) {
            throw new IllegalArgumentException("failed to perform topological sort, graph has a cycle");
        }
        return result2;
    }

    private int decrementAndGetCount(VertexT vertex) {
        Integer count2 = this.vertices.get(vertex);
        count2 = count2 - 1;
        this.vertices.put(vertex, count2);
        return count2;
    }
}

