/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VIntCoding {
    private static final ThreadLocal<byte[]> encodingBuffer = ThreadLocal.withInitial(() -> new byte[9]);

    private static long readUnsignedVInt(DataInput input2) throws IOException {
        byte firstByte = input2.readByte();
        if (firstByte >= 0) {
            return firstByte;
        }
        int size2 = VIntCoding.numberOfExtraBytesToRead(firstByte);
        long retval = firstByte & VIntCoding.firstByteValueMask(size2);
        for (int ii = 0; ii < size2; ++ii) {
            byte b = input2.readByte();
            retval <<= 8;
            retval |= (long)(b & 0xFF);
        }
        return retval;
    }

    public static long readVInt(DataInput input2) throws IOException {
        return VIntCoding.decodeZigZag64(VIntCoding.readUnsignedVInt(input2));
    }

    private static int firstByteValueMask(int extraBytesToRead) {
        return 255 >> extraBytesToRead;
    }

    private static byte encodeExtraBytesToRead(int extraBytesToRead) {
        return (byte)(~VIntCoding.firstByteValueMask(extraBytesToRead));
    }

    private static int numberOfExtraBytesToRead(int firstByte) {
        return Integer.numberOfLeadingZeros(~firstByte) - 24;
    }

    private static void writeUnsignedVInt(long value2, DataOutput output) throws IOException {
        int size2 = VIntCoding.computeUnsignedVIntSize(value2);
        if (size2 == 1) {
            output.write((int)value2);
            return;
        }
        output.write(VIntCoding.encodeVInt(value2, size2), 0, size2);
    }

    private static byte[] encodeVInt(long value2, int size2) {
        int extraBytes;
        byte[] encodingSpace = encodingBuffer.get();
        for (int i = extraBytes = size2 - 1; i >= 0; --i) {
            encodingSpace[i] = (byte)value2;
            value2 >>= 8;
        }
        encodingSpace[0] = (byte)(encodingSpace[0] | VIntCoding.encodeExtraBytesToRead(extraBytes));
        return encodingSpace;
    }

    public static void writeVInt(long value2, DataOutput output) throws IOException {
        VIntCoding.writeUnsignedVInt(VIntCoding.encodeZigZag64(value2), output);
    }

    private static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int computeVIntSize(long param2) {
        return VIntCoding.computeUnsignedVIntSize(VIntCoding.encodeZigZag64(param2));
    }

    private static int computeUnsignedVIntSize(long value2) {
        int magnitude = Long.numberOfLeadingZeros(value2 | 1L);
        return 639 - magnitude * 9 >> 6;
    }
}

