/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ZonedTimestampCodec
extends MappingCodec<Instant, ZonedDateTime> {
    private final ZoneId timeZone;

    public ZonedTimestampCodec() {
        this(ZoneId.systemDefault());
    }

    public ZonedTimestampCodec(ZoneId timeZone) {
        super(new TimestampCodec(Objects.requireNonNull(timeZone, "timeZone cannot be null")), GenericType.ZONED_DATE_TIME);
        this.timeZone = timeZone;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof ZonedDateTime;
    }

    @Override
    @Nullable
    protected ZonedDateTime innerToOuter(@Nullable Instant value2) {
        return value2 == null ? null : value2.atZone(this.timeZone);
    }

    @Override
    @Nullable
    protected Instant outerToInner(@Nullable ZonedDateTime value2) {
        return value2 == null ? null : value2.toInstant();
    }
}

