/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveLongCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class TimestampMillisCodec
implements PrimitiveLongCodec {
    private final TimestampCodec timestampCodec;

    public TimestampMillisCodec() {
        this(ZoneId.systemDefault());
    }

    public TimestampMillisCodec(ZoneId defaultZoneId) {
        this.timestampCodec = new TimestampCodec(defaultZoneId);
    }

    @Override
    @NonNull
    public GenericType<Long> getJavaType() {
        return GenericType.LONG;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TIMESTAMP;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Long.class || javaClass == Long.TYPE;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof Long;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(long value2, @NonNull ProtocolVersion protocolVersion) {
        return TypeCodecs.BIGINT.encodePrimitive(value2, protocolVersion);
    }

    @Override
    public long decodePrimitive(@Nullable ByteBuffer value2, @NonNull ProtocolVersion protocolVersion) {
        return TypeCodecs.BIGINT.decodePrimitive(value2, protocolVersion);
    }

    @Override
    @Nullable
    public Long parse(@Nullable String value2) {
        Instant instant = this.timestampCodec.parse(value2);
        return instant == null ? null : Long.valueOf(instant.toEpochMilli());
    }

    @Override
    @NonNull
    public String format(@Nullable Long value2) {
        Instant instant = value2 == null ? null : Instant.ofEpochMilli(value2);
        return this.timestampCodec.format(instant);
    }
}

