/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.time;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class LocalTimestampCodec
extends MappingCodec<Instant, LocalDateTime> {
    private final ZoneId timeZone;

    public LocalTimestampCodec() {
        this(ZoneId.systemDefault());
    }

    public LocalTimestampCodec(@NonNull ZoneId timeZone) {
        super(new TimestampCodec(Objects.requireNonNull(timeZone, "timeZone cannot be null")), GenericType.LOCAL_DATE_TIME);
        this.timeZone = timeZone;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof LocalDateTime;
    }

    @Override
    @Nullable
    protected LocalDateTime innerToOuter(@Nullable Instant value2) {
        return value2 == null ? null : LocalDateTime.ofInstant(value2, this.timeZone);
    }

    @Override
    @Nullable
    protected Instant outerToInner(@Nullable LocalDateTime value2) {
        return value2 == null ? null : value2.atZone(this.timeZone).toInstant();
    }
}

