/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.enums;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class EnumOrdinalCodec<EnumT extends Enum<EnumT>>
extends MappingCodec<Integer, EnumT> {
    private final EnumT[] enumConstants;

    public EnumOrdinalCodec(@NonNull Class<EnumT> enumClass) {
        super(TypeCodecs.INT, GenericType.of(Objects.requireNonNull(enumClass, "enumClass must not be null")));
        this.enumConstants = (Enum[])enumClass.getEnumConstants();
    }

    @Override
    @Nullable
    protected EnumT innerToOuter(@Nullable Integer value2) {
        return value2 == null ? null : (EnumT)this.enumConstants[value2];
    }

    @Override
    @Nullable
    protected Integer outerToInner(@Nullable EnumT value2) {
        return value2 == null ? null : Integer.valueOf(((Enum)value2).ordinal());
    }
}

