/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.enums;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class EnumNameCodec<EnumT extends Enum<EnumT>>
extends MappingCodec<String, EnumT> {
    private final Class<EnumT> enumClass;

    public EnumNameCodec(@NonNull Class<EnumT> enumClass) {
        super(TypeCodecs.TEXT, GenericType.of(Objects.requireNonNull(enumClass, "enumClass must not be null")));
        this.enumClass = enumClass;
    }

    @Override
    @Nullable
    protected EnumT innerToOuter(@Nullable String value2) {
        return value2 == null || value2.isEmpty() ? null : (EnumT)Enum.valueOf(this.enumClass, value2);
    }

    @Override
    @Nullable
    protected String outerToInner(@Nullable EnumT value2) {
        return value2 == null ? null : ((Enum)value2).name();
    }
}

