/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ObjectListToArrayCodec<ElementT>
extends AbstractListToArrayCodec<ElementT[]> {
    private final TypeCodec<ElementT> elementCodec;

    public ObjectListToArrayCodec(@NonNull TypeCodec<ElementT> elementCodec) {
        super(DataTypes.listOf(Objects.requireNonNull(elementCodec, "elementCodec must not be null").getCqlType()), GenericType.arrayOf(elementCodec.getJavaType()));
        this.elementCodec = elementCodec;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        Class<?> clazz2 = value2.getClass();
        return clazz2.isArray() && clazz2.getComponentType().equals(this.elementCodec.getJavaType().getRawType());
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable ElementT[] value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] encodedElements = new ByteBuffer[value2.length];
        int toAllocate = 4;
        for (ElementT elt : value2) {
            ByteBuffer encodedElement;
            if (elt == null) {
                throw new NullPointerException("Collection elements cannot be null");
            }
            try {
                encodedElement = this.elementCodec.encode(elt, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Invalid type for %s element, expecting %s but got %s", this.cqlType, this.elementCodec.getJavaType(), elt.getClass()), e);
            }
            if (encodedElement == null) {
                throw new NullPointerException("Collection elements cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedElement;
            toAllocate += 4 + encodedElement.remaining();
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        result2.putInt(value2.length);
        for (ByteBuffer encodedElement : encodedElements) {
            result2.putInt(encodedElement.remaining());
            result2.put(encodedElement);
        }
        result2.flip();
        return result2;
    }

    @Override
    @Nullable
    public ElementT[] decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return this.newInstance(0);
        }
        ByteBuffer input2 = bytes2.duplicate();
        int size2 = input2.getInt();
        ElementT[] result2 = this.newInstance(size2);
        for (int i = 0; i < size2; ++i) {
            Object element;
            int elementSize = input2.getInt();
            if (elementSize < 0) {
                element = null;
            } else {
                ByteBuffer encodedElement = input2.slice();
                encodedElement.limit(elementSize);
                element = this.elementCodec.decode(encodedElement, protocolVersion);
                input2.position(input2.position() + elementSize);
            }
            result2[i] = element;
        }
        return result2;
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull ElementT[] array2, int index2) {
        output.append(this.elementCodec.format(array2[index2]));
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull ElementT[] array2, int index2) {
        array2[index2] = this.elementCodec.parse(input2);
    }

    @Override
    @NonNull
    protected ElementT[] newInstance(int size2) {
        return (Object[])Array.newInstance(this.getJavaType().getRawType().getComponentType(), size2);
    }
}

