/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class LongListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<long[]> {
    public LongListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.BIGINT), GenericType.of(long[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return long[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof long[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 8;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull long[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        output.putLong(array2[index2]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input2, @NonNull long[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        array2[index2] = input2.getLong();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull long[] array2, int index2) {
        output.append(array2[index2]);
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull long[] array2, int index2) {
        array2[index2] = Long.parseLong(input2);
    }

    @Override
    @NonNull
    protected long[] newInstance(int size2) {
        return new long[size2];
    }
}

