/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class IntListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<int[]> {
    public IntListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.INT), GenericType.of(int[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return int[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof int[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 4;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull int[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        output.putInt(array2[index2]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input2, @NonNull int[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        array2[index2] = input2.getInt();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull int[] array2, int index2) {
        output.append(array2[index2]);
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull int[] array2, int index2) {
        array2[index2] = Integer.parseInt(input2);
    }

    @Override
    @NonNull
    protected int[] newInstance(int size2) {
        return new int[size2];
    }
}

