/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class FloatListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<float[]> {
    public FloatListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.FLOAT), GenericType.of(float[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return float[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof float[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 4;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull float[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        output.putFloat(array2[index2]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input2, @NonNull float[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        array2[index2] = input2.getFloat();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull float[] array2, int index2) {
        output.append(array2[index2]);
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull float[] array2, int index2) {
        array2[index2] = Float.parseFloat(input2);
    }

    @Override
    @NonNull
    protected float[] newInstance(int size2) {
        return new float[size2];
    }
}

