/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DoubleListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<double[]> {
    public DoubleListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.DOUBLE), GenericType.of(double[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return double[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof double[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 8;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull double[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        output.putDouble(array2[index2]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input2, @NonNull double[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        array2[index2] = input2.getDouble();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull double[] array2, int index2) {
        output.append(array2[index2]);
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull double[] array2, int index2) {
        array2[index2] = Double.parseDouble(input2);
    }

    @Override
    @NonNull
    protected double[] newInstance(int size2) {
        return new double[size2];
    }
}

