/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ByteListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<byte[]> {
    public ByteListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.SMALLINT), GenericType.of(byte[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return byte[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof byte[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 1;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull byte[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        output.put(array2[index2]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input2, @NonNull byte[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        array2[index2] = input2.get();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull byte[] array2, int index2) {
        output.append(array2[index2]);
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull byte[] array2, int index2) {
        array2[index2] = Byte.parseByte(input2);
    }

    @Override
    @NonNull
    protected byte[] newInstance(int size2) {
        return new byte[size2];
    }
}

