/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class BooleanListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<boolean[]> {
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    public BooleanListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.BOOLEAN), GenericType.of(boolean[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return boolean[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        return value2 instanceof boolean[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 1;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull boolean[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        byte element = array2[index2] ? (byte)1 : 0;
        output.put(element);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input2, @NonNull boolean[] array2, int index2, @NonNull ProtocolVersion protocolVersion) {
        array2[index2] = input2.get() == 1;
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull boolean[] array2, int index2) {
        output.append(array2[index2]);
    }

    @Override
    protected void parseElement(@NonNull String input2, @NonNull boolean[] array2, int index2) {
        array2[index2] = Boolean.parseBoolean(input2);
    }

    @Override
    @NonNull
    protected boolean[] newInstance(int size2) {
        return new boolean[size2];
    }
}

