/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class AbstractPrimitiveListToArrayCodec<PrimitiveArrayT>
extends AbstractListToArrayCodec<PrimitiveArrayT> {
    protected AbstractPrimitiveListToArrayCodec(@NonNull ListType cqlType, @NonNull GenericType<PrimitiveArrayT> javaClass) {
        super(cqlType, javaClass);
        GenericType<?> componentType = Objects.requireNonNull(javaClass.getComponentType());
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("Expecting primitive array component type, got " + componentType);
        }
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable PrimitiveArrayT array2, @NonNull ProtocolVersion protocolVersion) {
        if (array2 == null) {
            return null;
        }
        int length = Array.getLength(array2);
        int sizeOfElement = 4 + this.sizeOfComponentType();
        int totalSize = 4 + length * sizeOfElement;
        ByteBuffer output = ByteBuffer.allocate(totalSize);
        output.putInt(length);
        for (int i = 0; i < length; ++i) {
            output.putInt(this.sizeOfComponentType());
            this.serializeElement(output, array2, i, protocolVersion);
        }
        output.flip();
        return output;
    }

    @Override
    @Nullable
    public PrimitiveArrayT decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return (PrimitiveArrayT)this.newInstance(0);
        }
        ByteBuffer input2 = bytes2.duplicate();
        int length = input2.getInt();
        Object array2 = this.newInstance(length);
        for (int i = 0; i < length; ++i) {
            int elementSize = input2.getInt();
            if (elementSize < 0) {
                throw new NullPointerException("Primitive arrays cannot store null elements");
            }
            this.deserializeElement(input2, array2, i, protocolVersion);
        }
        return (PrimitiveArrayT)array2;
    }

    protected abstract int sizeOfComponentType();

    protected abstract void serializeElement(@NonNull ByteBuffer var1, @NonNull PrimitiveArrayT var2, int var3, @NonNull ProtocolVersion var4);

    protected abstract void deserializeElement(@NonNull ByteBuffer var1, @NonNull PrimitiveArrayT var2, int var3, @NonNull ProtocolVersion var4);
}

