/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Array;
import java.util.Objects;

public abstract class AbstractListToArrayCodec<ArrayT>
implements TypeCodec<ArrayT> {
    @NonNull
    protected final ListType cqlType;
    @NonNull
    protected final GenericType<ArrayT> javaType;

    protected AbstractListToArrayCodec(@NonNull ListType cqlType, @NonNull GenericType<ArrayT> arrayType) {
        this.cqlType = Objects.requireNonNull(cqlType, "cqlType cannot be null");
        this.javaType = Objects.requireNonNull(arrayType, "arrayType cannot be null");
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Expecting Java array class, got " + arrayType);
        }
    }

    @Override
    @NonNull
    public GenericType<ArrayT> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    @NonNull
    public String format(@Nullable ArrayT array2) {
        if (array2 == null) {
            return "NULL";
        }
        int length = Array.getLength(array2);
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            this.formatElement(sb, array2, i);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    @Nullable
    public ArrayT parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = this.skipSpaces(value2, 0);
        idx = this.skipOpeningBracket(value2, idx);
        if (value2.charAt(idx = this.skipSpaces(value2, idx)) == ']') {
            return this.newInstance(0);
        }
        int length = this.getArrayLength(value2, idx);
        ArrayT array2 = this.newInstance(length);
        int i = 0;
        while (idx < value2.length()) {
            int n = this.skipLiteral(value2, idx);
            this.parseElement(value2.substring(idx, n), array2, i);
            idx = this.skipSpaces(value2, n);
            if (value2.charAt(idx) == ']') {
                return array2;
            }
            idx = this.skipComma(value2, idx);
            idx = this.skipSpaces(value2, idx);
            ++i;
        }
        throw new IllegalArgumentException(String.format("Malformed list value \"%s\", missing closing ']'", value2));
    }

    @NonNull
    protected abstract ArrayT newInstance(int var1);

    protected abstract void formatElement(@NonNull StringBuilder var1, @NonNull ArrayT var2, int var3);

    protected abstract void parseElement(@NonNull String var1, @NonNull ArrayT var2, int var3);

    private int getArrayLength(String value2, int idx) {
        int length = 1;
        while (idx < value2.length()) {
            idx = this.skipLiteral(value2, idx);
            if (value2.charAt(idx = this.skipSpaces(value2, idx)) == ']') break;
            idx = this.skipComma(value2, idx);
            idx = this.skipSpaces(value2, idx);
            ++length;
        }
        return length;
    }

    private int skipComma(String value2, int idx) {
        if (value2.charAt(idx) != ',') {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
        }
        return idx + 1;
    }

    private int skipOpeningBracket(String value2, int idx) {
        if (value2.charAt(idx) != '[') {
            throw new IllegalArgumentException(String.format("cannot parse list value from \"%s\", at character %d expecting '[' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
        }
        return idx + 1;
    }

    private int skipSpaces(String value2, int idx) {
        try {
            return ParseUtils.skipSpaces(value2, idx);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting space but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))), e);
        }
    }

    private int skipLiteral(String value2, int idx) {
        try {
            return ParseUtils.skipCQLValue(value2, idx);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", invalid CQL value at character %d", value2, idx), e);
        }
    }
}

