/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras;

import com.datastax.oss.driver.api.core.type.codec.MappingCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;

@Immutable
public class OptionalCodec<T>
extends MappingCodec<T, Optional<T>> {
    public OptionalCodec(@NonNull TypeCodec<T> innerCodec) {
        super(Objects.requireNonNull(innerCodec, "innerCodec must not be null"), GenericType.optionalOf(innerCodec.getJavaType()));
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        Objects.requireNonNull(value2);
        if (value2 instanceof Optional) {
            Optional optional = (Optional)value2;
            return optional.map(this.innerCodec::accepts).orElse(true);
        }
        return false;
    }

    @Override
    @Nullable
    protected Optional<T> innerToOuter(@Nullable T value2) {
        return Optional.ofNullable(this.isAbsent(value2) ? null : (Object)value2);
    }

    @Override
    @Nullable
    protected T outerToInner(@Nullable Optional<T> value2) {
        return value2 != null && value2.isPresent() ? (T)value2.get() : null;
    }

    protected boolean isAbsent(@Nullable T value2) {
        return value2 == null || value2 instanceof Collection && ((Collection)value2).isEmpty() || value2 instanceof Map && ((Map)value2).isEmpty();
    }
}

