/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class VarIntCodec
implements TypeCodec<BigInteger> {
    @Override
    @NonNull
    public GenericType<BigInteger> getJavaType() {
        return GenericType.BIG_INTEGER;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.VARINT;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof BigInteger;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return BigInteger.class.isAssignableFrom(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable BigInteger value2, @NonNull ProtocolVersion protocolVersion) {
        return value2 == null ? null : ByteBuffer.wrap(value2.toByteArray());
    }

    @Override
    @Nullable
    public BigInteger decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        return bytes2 == null || bytes2.remaining() == 0 ? null : new BigInteger(Bytes.getArray(bytes2));
    }

    @Override
    @NonNull
    public String format(@Nullable BigInteger value2) {
        return value2 == null ? "NULL" : value2.toString();
    }

    @Override
    @Nullable
    public BigInteger parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : new BigInteger(value2);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse varint value from \"%s\"", value2), e);
        }
    }
}

