/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UuidCodec
implements TypeCodec<UUID> {
    @Override
    @NonNull
    public GenericType<UUID> getJavaType() {
        return GenericType.UUID;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.UUID;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof UUID;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == UUID.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable UUID value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        ByteBuffer bytes2 = ByteBuffer.allocate(16);
        bytes2.putLong(0, value2.getMostSignificantBits());
        bytes2.putLong(8, value2.getLeastSignificantBits());
        return bytes2;
    }

    @Override
    @Nullable
    public UUID decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return null;
        }
        if (bytes2.remaining() != 16) {
            throw new IllegalArgumentException("Unexpected number of bytes for a UUID, expected 16, got " + bytes2.remaining());
        }
        return new UUID(bytes2.getLong(bytes2.position()), bytes2.getLong(bytes2.position() + 8));
    }

    @Override
    @NonNull
    public String format(@Nullable UUID value2) {
        return value2 == null ? "NULL" : value2.toString();
    }

    @Override
    @Nullable
    public UUID parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : UUID.fromString(value2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot parse UUID value from \"%s\"", value2), e);
        }
    }
}

