/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UdtCodec
implements TypeCodec<UdtValue> {
    private final UserDefinedType cqlType;

    public UdtCodec(@NonNull UserDefinedType cqlType) {
        this.cqlType = cqlType;
    }

    @Override
    @NonNull
    public GenericType<UdtValue> getJavaType() {
        return GenericType.UDT_VALUE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof UdtValue && ((UdtValue)value2).getType().equals(this.cqlType);
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return UdtValue.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable UdtValue value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        if (!value2.getType().equals(this.cqlType)) {
            throw new IllegalArgumentException(String.format("Invalid user defined type, expected %s but got %s", this.cqlType, value2.getType()));
        }
        int toAllocate = 0;
        int size2 = this.cqlType.getFieldTypes().size();
        for (int i = 0; i < size2; ++i) {
            ByteBuffer field2 = value2.getBytesUnsafe(i);
            toAllocate += 4 + (field2 == null ? 0 : field2.remaining());
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        for (int i = 0; i < value2.size(); ++i) {
            ByteBuffer field3 = value2.getBytesUnsafe(i);
            if (field3 == null) {
                result2.putInt(-1);
                continue;
            }
            result2.putInt(field3.remaining());
            result2.put(field3.duplicate());
        }
        return (ByteBuffer)result2.flip();
    }

    @Override
    @Nullable
    public UdtValue decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null) {
            return null;
        }
        try {
            ByteBuffer input2 = bytes2.duplicate();
            UdtValue value2 = this.cqlType.newValue();
            int i = 0;
            while (input2.hasRemaining()) {
                ByteBuffer element;
                if (i > this.cqlType.getFieldTypes().size()) {
                    throw new IllegalArgumentException(String.format("Too many fields in encoded UDT value, expected %d", this.cqlType.getFieldTypes().size()));
                }
                int elementSize = input2.getInt();
                if (elementSize < 0) {
                    element = null;
                } else {
                    element = input2.slice();
                    element.limit(elementSize);
                    input2.position(input2.position() + elementSize);
                }
                value2 = (UdtValue)value2.setBytesUnsafe(i, element);
                ++i;
            }
            return value2;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Not enough bytes to deserialize a UDT value", e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable UdtValue value2) {
        if (value2 == null) {
            return "NULL";
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        StringBuilder sb = new StringBuilder("{");
        int size2 = this.cqlType.getFieldTypes().size();
        boolean first = true;
        for (int i = 0; i < size2; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            CqlIdentifier elementName = this.cqlType.getFieldNames().get(i);
            sb.append(elementName.asCql(true));
            sb.append(":");
            DataType elementType2 = this.cqlType.getFieldTypes().get(i);
            TypeCodec<DataType> codec = registry.codecFor(elementType2);
            sb.append(codec.format(value2.get(i, codec)));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @Nullable
    public UdtValue parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        UdtValue udt2 = this.cqlType.newValue();
        int length = value2.length();
        int position2 = ParseUtils.skipSpaces(value2, 0);
        if (value2.charAt(position2) != '{') {
            throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\" at character %d: expecting '{' but got '%c'", value2, position2, Character.valueOf(value2.charAt(position2))));
        }
        ++position2;
        if ((position2 = ParseUtils.skipSpaces(value2, position2)) == length) {
            throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\" at character %d: expecting CQL identifier or '}', got EOF", value2, position2));
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        CqlIdentifier id = null;
        while (position2 < length) {
            DataType parsed;
            int n;
            if (value2.charAt(position2) == '}') {
                if ((position2 = ParseUtils.skipSpaces(value2, position2 + 1)) == length) {
                    return udt2;
                }
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting EOF or blank, but got \"%s\"", value2, position2, value2.substring(position2)));
            }
            try {
                n = ParseUtils.skipCQLId(value2, position2);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", cannot parse a CQL identifier at character %d", value2, position2), e);
            }
            id = CqlIdentifier.fromInternal(value2.substring(position2, n));
            position2 = n;
            if (!this.cqlType.contains(id)) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", unknown CQL identifier at character %d: \"%s\"", value2, position2, id));
            }
            if ((position2 = ParseUtils.skipSpaces(value2, position2)) == length) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ':', but got EOF", value2, id, position2));
            }
            if (value2.charAt(position2) != ':') {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ':', but got '%c'", value2, id, position2, Character.valueOf(value2.charAt(position2))));
            }
            ++position2;
            position2 = ParseUtils.skipSpaces(value2, position2);
            try {
                n = ParseUtils.skipCQLValue(value2, position2);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", invalid CQL value at field %s (character %d)", value2, id, position2), e);
            }
            String fieldValue = value2.substring(position2, n);
            DataType fieldType = this.cqlType.getFieldTypes().get(this.cqlType.firstIndexOf(id));
            TypeCodec<DataType> codec = registry.codecFor(fieldType);
            try {
                parsed = codec.parse(fieldValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", invalid CQL value at field %s (character %d): %s", value2, id, position2, e.getMessage()), e);
            }
            udt2 = (UdtValue)udt2.set(id, parsed, codec);
            position2 = n;
            position2 = ParseUtils.skipSpaces(value2, position2);
            if (position2 == length) {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ',' or '}', but got EOF", value2, id, position2));
            }
            if (value2.charAt(position2) == '}') continue;
            if (value2.charAt(position2) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\", at field %s (character %d) expecting ',' but got '%c'", value2, id, position2, Character.valueOf(value2.charAt(position2))));
            }
            ++position2;
            position2 = ParseUtils.skipSpaces(value2, position2);
        }
        throw new IllegalArgumentException(String.format("Cannot parse UDT value from \"%s\" at field %s (character %d): expecting CQL identifier or '}', got EOF", value2, id, position2));
    }
}

