/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TupleCodec
implements TypeCodec<TupleValue> {
    private final TupleType cqlType;

    public TupleCodec(@NonNull TupleType cqlType) {
        this.cqlType = cqlType;
    }

    @Override
    @NonNull
    public GenericType<TupleValue> getJavaType() {
        return GenericType.TUPLE_VALUE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof TupleValue && ((TupleValue)value2).getType().equals(this.cqlType);
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return TupleValue.class.equals(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable TupleValue value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        if (!value2.getType().equals(this.cqlType)) {
            throw new IllegalArgumentException(String.format("Invalid tuple type, expected %s but got %s", this.cqlType, value2.getType()));
        }
        int toAllocate = 0;
        for (int i = 0; i < value2.size(); ++i) {
            ByteBuffer field2 = value2.getBytesUnsafe(i);
            toAllocate += 4 + (field2 == null ? 0 : field2.remaining());
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        for (int i = 0; i < value2.size(); ++i) {
            ByteBuffer field3 = value2.getBytesUnsafe(i);
            if (field3 == null) {
                result2.putInt(-1);
                continue;
            }
            result2.putInt(field3.remaining());
            result2.put(field3.duplicate());
        }
        return (ByteBuffer)result2.flip();
    }

    @Override
    @Nullable
    public TupleValue decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null) {
            return null;
        }
        try {
            ByteBuffer input2 = bytes2.duplicate();
            TupleValue value2 = this.cqlType.newValue();
            int i = 0;
            while (input2.hasRemaining()) {
                ByteBuffer element;
                if (i > this.cqlType.getComponentTypes().size()) {
                    throw new IllegalArgumentException(String.format("Too many fields in encoded tuple, expected %d", this.cqlType.getComponentTypes().size()));
                }
                int elementSize = input2.getInt();
                if (elementSize < 0) {
                    element = null;
                } else {
                    element = input2.slice();
                    element.limit(elementSize);
                    input2.position(input2.position() + elementSize);
                }
                value2 = (TupleValue)value2.setBytesUnsafe(i, element);
                ++i;
            }
            return value2;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Not enough bytes to deserialize a tuple", e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable TupleValue value2) {
        if (value2 == null) {
            return "NULL";
        }
        if (!value2.getType().equals(this.cqlType)) {
            throw new IllegalArgumentException(String.format("Invalid tuple type, expected %s but got %s", this.cqlType, value2.getType()));
        }
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (int i = 0; i < value2.size(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            DataType elementType2 = this.cqlType.getComponentTypes().get(i);
            TypeCodec<DataType> codec = registry.codecFor(elementType2);
            sb.append(codec.format(value2.get(i, codec)));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    @Nullable
    public TupleValue parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        TupleValue tuple2 = this.cqlType.newValue();
        int length = value2.length();
        int position2 = ParseUtils.skipSpaces(value2, 0);
        if (value2.charAt(position2) != '(') {
            throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting '(' but got '%c'", value2, position2, Character.valueOf(value2.charAt(position2))));
        }
        ++position2;
        position2 = ParseUtils.skipSpaces(value2, position2);
        CodecRegistry registry = this.cqlType.getAttachmentPoint().getCodecRegistry();
        int field2 = 0;
        while (position2 < length) {
            DataType parsed;
            int n;
            if (value2.charAt(position2) == ')') {
                if ((position2 = ParseUtils.skipSpaces(value2, position2 + 1)) == length) {
                    return tuple2;
                }
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting EOF or blank, but got \"%s\"", value2, position2, value2.substring(position2)));
            }
            try {
                n = ParseUtils.skipCQLValue(value2, position2);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", invalid CQL value at field %d (character %d)", value2, field2, position2), e);
            }
            String fieldValue = value2.substring(position2, n);
            DataType elementType2 = this.cqlType.getComponentTypes().get(field2);
            TypeCodec<DataType> codec = registry.codecFor(elementType2);
            try {
                parsed = codec.parse(fieldValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", invalid CQL value at field %d (character %d): %s", value2, field2, position2, e.getMessage()), e);
            }
            tuple2 = (TupleValue)tuple2.set(field2, parsed, codec);
            position2 = n;
            position2 = ParseUtils.skipSpaces(value2, position2);
            if (position2 == length) {
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at field %d (character %d) expecting ',' or ')', but got EOF", value2, field2, position2));
            }
            if (value2.charAt(position2) == ')') continue;
            if (value2.charAt(position2) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at field %d (character %d) expecting ',' but got '%c'", value2, field2, position2, Character.valueOf(value2.charAt(position2))));
            }
            ++position2;
            position2 = ParseUtils.skipSpaces(value2, position2);
            ++field2;
        }
        throw new IllegalArgumentException(String.format("Cannot parse tuple value from \"%s\", at field %d (character %d) expecting CQL value or ')', got EOF", value2, field2, position2));
    }
}

