/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveByteCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TinyIntCodec
implements PrimitiveByteCodec {
    @Override
    @NonNull
    public GenericType<Byte> getJavaType() {
        return GenericType.BYTE;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TINYINT;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Byte;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Byte.class || javaClass == Byte.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(byte value2, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes2 = ByteBuffer.allocate(1);
        bytes2.put(0, value2);
        return bytes2;
    }

    @Override
    public byte decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return 0;
        }
        if (bytes2.remaining() != 1) {
            throw new IllegalArgumentException("Invalid 8-bits integer value, expecting 1 byte but got " + bytes2.remaining());
        }
        return bytes2.get(bytes2.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Byte value2) {
        return value2 == null ? "NULL" : Byte.toString(value2);
    }

    @Override
    @Nullable
    public Byte parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Byte.valueOf(Byte.parseByte(value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 8-bits int value from \"%s\"", value2));
        }
    }
}

