/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.internal.core.type.codec.UuidCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TimeUuidCodec
extends UuidCodec {
    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TIMEUUID;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof UUID && ((UUID)value2).version() == 1;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == UUID.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable UUID value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        if (value2.version() != 1) {
            throw new IllegalArgumentException(String.format("%s is not a Type 1 (time-based) UUID", value2));
        }
        return super.encode(value2, protocolVersion);
    }

    @Override
    @NonNull
    public String format(@Nullable UUID value2) {
        if (value2 == null) {
            return "NULL";
        }
        if (value2.version() != 1) {
            throw new IllegalArgumentException(String.format("%s is not a Type 1 (time-based) UUID", value2));
        }
        return super.format(value2);
    }
}

