/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class StringCodec
implements TypeCodec<String> {
    private final DataType cqlType;
    private final FastThreadLocal<CharsetEncoder> charsetEncoder;
    private final FastThreadLocal<CharsetDecoder> charsetDecoder;

    public StringCodec(@NonNull DataType cqlType, final @NonNull Charset charset) {
        this.cqlType = cqlType;
        this.charsetEncoder = new FastThreadLocal<CharsetEncoder>(){

            @Override
            protected CharsetEncoder initialValue() throws Exception {
                return charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        };
        this.charsetDecoder = new FastThreadLocal<CharsetDecoder>(){

            @Override
            protected CharsetDecoder initialValue() throws Exception {
                return charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            }
        };
    }

    @Override
    @NonNull
    public GenericType<String> getJavaType() {
        return GenericType.STRING;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof String;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == String.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable String value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        try {
            return this.charsetEncoder.get().encode(CharBuffer.wrap(value2));
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @Nullable
    public String decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null) {
            return null;
        }
        if (bytes2.remaining() == 0) {
            return "";
        }
        try {
            return this.charsetDecoder.get().decode(bytes2.duplicate()).toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    @NonNull
    public String format(@Nullable String value2) {
        return value2 == null ? "NULL" : Strings.quote(value2);
    }

    @Override
    @Nullable
    public String parse(String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(value2)) {
            throw new IllegalArgumentException("text or varchar values must be enclosed by single quotes");
        }
        return Strings.unquote(value2);
    }
}

