/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveShortCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SmallIntCodec
implements PrimitiveShortCodec {
    @Override
    @NonNull
    public GenericType<Short> getJavaType() {
        return GenericType.SHORT;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.SMALLINT;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Short;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Short.class || javaClass == Short.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(short value2, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes2 = ByteBuffer.allocate(2);
        bytes2.putShort(0, value2);
        return bytes2;
    }

    @Override
    public short decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return 0;
        }
        if (bytes2.remaining() != 2) {
            throw new IllegalArgumentException("Invalid 16-bits integer value, expecting 2 bytes but got " + bytes2.remaining());
        }
        return bytes2.getShort(bytes2.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Short value2) {
        return value2 == null ? "NULL" : Short.toString(value2);
    }

    @Override
    @Nullable
    public Short parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Short.valueOf(Short.parseShort(value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 16-bits int value from \"%s\"", value2));
        }
    }
}

