/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class SetCodec<ElementT>
implements TypeCodec<Set<ElementT>> {
    private final DataType cqlType;
    private final GenericType<Set<ElementT>> javaType;
    private final TypeCodec<ElementT> elementCodec;

    public SetCodec(DataType cqlType, TypeCodec<ElementT> elementCodec) {
        this.cqlType = cqlType;
        this.javaType = GenericType.setOf(elementCodec.getJavaType());
        this.elementCodec = elementCodec;
        Preconditions.checkArgument(cqlType instanceof SetType);
    }

    @Override
    @NonNull
    public GenericType<Set<ElementT>> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        if (Set.class.isAssignableFrom(value2.getClass())) {
            Set set2 = (Set)value2;
            return set2.isEmpty() || this.elementCodec.accepts(set2.iterator().next());
        }
        return false;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable Set<ElementT> value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] encodedElements = new ByteBuffer[value2.size()];
        int toAllocate = 4;
        for (ElementT element : value2) {
            ByteBuffer encodedElement;
            if (element == null) {
                throw new NullPointerException("Collection elements cannot be null");
            }
            try {
                encodedElement = this.elementCodec.encode(element, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type for element: " + element.getClass());
            }
            if (encodedElement == null) {
                throw new NullPointerException("Collection elements cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedElement;
            toAllocate += 4 + encodedElement.remaining();
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        result2.putInt(value2.size());
        for (ByteBuffer encodedElement : encodedElements) {
            result2.putInt(encodedElement.remaining());
            result2.put(encodedElement);
        }
        result2.flip();
        return result2;
    }

    @Override
    @Nullable
    public Set<ElementT> decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return new LinkedHashSet(0);
        }
        ByteBuffer input2 = bytes2.duplicate();
        int size2 = input2.getInt();
        LinkedHashSet<Object> result2 = Sets.newLinkedHashSetWithExpectedSize(size2);
        for (int i = 0; i < size2; ++i) {
            Object element;
            int elementSize = input2.getInt();
            if (elementSize < 0) {
                element = null;
            } else {
                ByteBuffer encodedElement = input2.slice();
                encodedElement.limit(elementSize);
                element = this.elementCodec.decode(encodedElement, protocolVersion);
                input2.position(input2.position() + elementSize);
            }
            result2.add(element);
        }
        return result2;
    }

    @Override
    @NonNull
    public String format(@Nullable Set<ElementT> value2) {
        if (value2 == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (ElementT t : value2) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.elementCodec.format(t));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @Nullable
    public Set<ElementT> parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = ParseUtils.skipSpaces(value2, 0);
        if (value2.charAt(idx++) != '{') {
            throw new IllegalArgumentException(String.format("Cannot parse set value from \"%s\", at character %d expecting '{' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
        }
        if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == '}') {
            return new LinkedHashSet(0);
        }
        LinkedHashSet<ElementT> set2 = new LinkedHashSet<ElementT>();
        while (idx < value2.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLValue(value2, idx);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse set value from \"%s\", invalid CQL value at character %d", value2, idx), e);
            }
            set2.add(this.elementCodec.parse(value2.substring(idx, n)));
            idx = n;
            idx = ParseUtils.skipSpaces(value2, idx);
            if (value2.charAt(idx) == '}') {
                return set2;
            }
            if (value2.charAt(idx++) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse set value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            idx = ParseUtils.skipSpaces(value2, idx);
        }
        throw new IllegalArgumentException(String.format("Malformed set value \"%s\", missing closing '}'", value2));
    }
}

