/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MapCodec<KeyT, ValueT>
implements TypeCodec<Map<KeyT, ValueT>> {
    private final DataType cqlType;
    private final GenericType<Map<KeyT, ValueT>> javaType;
    private final TypeCodec<KeyT> keyCodec;
    private final TypeCodec<ValueT> valueCodec;

    public MapCodec(DataType cqlType, TypeCodec<KeyT> keyCodec, TypeCodec<ValueT> valueCodec) {
        this.cqlType = cqlType;
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
        this.javaType = GenericType.mapOf(keyCodec.getJavaType(), valueCodec.getJavaType());
    }

    @Override
    @NonNull
    public GenericType<Map<KeyT, ValueT>> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            if (map2.isEmpty()) {
                return true;
            }
            Map.Entry entry2 = map2.entrySet().iterator().next();
            return this.keyCodec.accepts(entry2.getKey()) && this.valueCodec.accepts(entry2.getValue());
        }
        return false;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable Map<KeyT, ValueT> value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] encodedElements = new ByteBuffer[value2.size() * 2];
        int toAllocate = 4;
        for (Map.Entry<KeyT, ValueT> entry2 : value2.entrySet()) {
            ByteBuffer encodedValue;
            ByteBuffer encodedKey;
            if (entry2.getKey() == null) {
                throw new NullPointerException("Map keys cannot be null");
            }
            if (entry2.getValue() == null) {
                throw new NullPointerException("Map values cannot be null");
            }
            try {
                encodedKey = this.keyCodec.encode(entry2.getKey(), protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type for key: " + entry2.getKey().getClass());
            }
            if (encodedKey == null) {
                throw new NullPointerException("Map keys cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedKey;
            toAllocate += 4 + encodedKey.remaining();
            try {
                encodedValue = this.valueCodec.encode(entry2.getValue(), protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type for value: " + entry2.getValue().getClass());
            }
            if (encodedValue == null) {
                throw new NullPointerException("Map values cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedValue;
            toAllocate += 4 + encodedValue.remaining();
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        result2.putInt(value2.size());
        for (ByteBuffer encodedElement : encodedElements) {
            result2.putInt(encodedElement.remaining());
            result2.put(encodedElement);
        }
        result2.flip();
        return result2;
    }

    @Override
    @Nullable
    public Map<KeyT, ValueT> decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return new LinkedHashMap(0);
        }
        ByteBuffer input2 = bytes2.duplicate();
        int size2 = input2.getInt();
        LinkedHashMap<Object, Object> result2 = Maps.newLinkedHashMapWithExpectedSize(size2);
        for (int i = 0; i < size2; ++i) {
            Object value2;
            Object key;
            int keySize = input2.getInt();
            if (keySize < 0) {
                key = null;
            } else {
                ByteBuffer encodedKey = input2.slice();
                encodedKey.limit(keySize);
                key = this.keyCodec.decode(encodedKey, protocolVersion);
                input2.position(input2.position() + keySize);
            }
            int valueSize = input2.getInt();
            if (valueSize < 0) {
                value2 = null;
            } else {
                ByteBuffer encodedValue = input2.slice();
                encodedValue.limit(valueSize);
                value2 = this.valueCodec.decode(encodedValue, protocolVersion);
                input2.position(input2.position() + valueSize);
            }
            result2.put(key, value2);
        }
        return result2;
    }

    @Override
    @NonNull
    public String format(@Nullable Map<KeyT, ValueT> value2) {
        if (value2 == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<KeyT, ValueT> e : value2.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.keyCodec.format(e.getKey()));
            sb.append(":");
            sb.append(this.valueCodec.format(e.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @Nullable
    public Map<KeyT, ValueT> parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = ParseUtils.skipSpaces(value2, 0);
        if (value2.charAt(idx++) != '{') {
            throw new IllegalArgumentException(String.format("cannot parse map value from \"%s\", at character %d expecting '{' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
        }
        if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == '}') {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<KeyT, ValueT> map2 = new LinkedHashMap<KeyT, ValueT>();
        while (idx < value2.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLValue(value2, idx);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value2, idx), e);
            }
            KeyT k = this.keyCodec.parse(value2.substring(idx, n));
            idx = n;
            idx = ParseUtils.skipSpaces(value2, idx);
            if (value2.charAt(idx++) != ':') {
                throw new IllegalArgumentException(String.format("Cannot parse map value from \"%s\", at character %d expecting ':' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            idx = ParseUtils.skipSpaces(value2, idx);
            try {
                n = ParseUtils.skipCQLValue(value2, idx);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value2, idx), e);
            }
            ValueT v = this.valueCodec.parse(value2.substring(idx, n));
            idx = n;
            map2.put(k, v);
            idx = ParseUtils.skipSpaces(value2, idx);
            if (value2.charAt(idx) == '}') {
                return map2;
            }
            if (value2.charAt(idx++) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse map value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            idx = ParseUtils.skipSpaces(value2, idx);
        }
        throw new IllegalArgumentException(String.format("Malformed map value \"%s\", missing closing '}'", value2));
    }
}

