/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ListCodec<ElementT>
implements TypeCodec<List<ElementT>> {
    private final DataType cqlType;
    private final GenericType<List<ElementT>> javaType;
    private final TypeCodec<ElementT> elementCodec;

    public ListCodec(DataType cqlType, TypeCodec<ElementT> elementCodec) {
        this.cqlType = cqlType;
        this.javaType = GenericType.listOf(elementCodec.getJavaType());
        this.elementCodec = elementCodec;
        Preconditions.checkArgument(cqlType instanceof ListType);
    }

    @Override
    @NonNull
    public GenericType<List<ElementT>> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        if (List.class.isAssignableFrom(value2.getClass())) {
            List list2 = (List)value2;
            return list2.isEmpty() || this.elementCodec.accepts(list2.get(0));
        }
        return false;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable List<ElementT> value2, @NonNull ProtocolVersion protocolVersion) {
        if (value2 == null) {
            return null;
        }
        int i = 0;
        ByteBuffer[] encodedElements = new ByteBuffer[value2.size()];
        int toAllocate = 4;
        for (ElementT element : value2) {
            ByteBuffer encodedElement;
            if (element == null) {
                throw new NullPointerException("Collection elements cannot be null");
            }
            try {
                encodedElement = this.elementCodec.encode(element, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type for element: " + element.getClass());
            }
            if (encodedElement == null) {
                throw new NullPointerException("Collection elements cannot encode to CQL NULL");
            }
            encodedElements[i++] = encodedElement;
            toAllocate += 4 + encodedElement.remaining();
        }
        ByteBuffer result2 = ByteBuffer.allocate(toAllocate);
        result2.putInt(value2.size());
        for (ByteBuffer encodedElement : encodedElements) {
            result2.putInt(encodedElement.remaining());
            result2.put(encodedElement);
        }
        result2.flip();
        return result2;
    }

    @Override
    @Nullable
    public List<ElementT> decode(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return new ArrayList(0);
        }
        ByteBuffer input2 = bytes2.duplicate();
        int size2 = input2.getInt();
        ArrayList<Object> result2 = new ArrayList<Object>(size2);
        for (int i = 0; i < size2; ++i) {
            Object element;
            int elementSize = input2.getInt();
            if (elementSize < 0) {
                element = null;
            } else {
                ByteBuffer encodedElement = input2.slice();
                encodedElement.limit(elementSize);
                element = this.elementCodec.decode(encodedElement, protocolVersion);
                input2.position(input2.position() + elementSize);
            }
            result2.add(element);
        }
        return result2;
    }

    @Override
    @NonNull
    public String format(@Nullable List<ElementT> value2) {
        if (value2 == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (ElementT t : value2) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(this.elementCodec.format(t));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    @Nullable
    public List<ElementT> parse(@Nullable String value2) {
        if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = ParseUtils.skipSpaces(value2, 0);
        if (value2.charAt(idx++) != '[') {
            throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting '[' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
        }
        if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == ']') {
            return new ArrayList(0);
        }
        ArrayList<ElementT> list2 = new ArrayList<ElementT>();
        while (idx < value2.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLValue(value2, idx);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", invalid CQL value at character %d", value2, idx), e);
            }
            list2.add(this.elementCodec.parse(value2.substring(idx, n)));
            idx = n;
            idx = ParseUtils.skipSpaces(value2, idx);
            if (value2.charAt(idx) == ']') {
                return list2;
            }
            if (value2.charAt(idx++) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse list value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            idx = ParseUtils.skipSpaces(value2, idx);
        }
        throw new IllegalArgumentException(String.format("Malformed list value \"%s\", missing closing ']'", value2));
    }
}

