/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.PrimitiveIntCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IntCodec
implements PrimitiveIntCodec {
    @Override
    @NonNull
    public GenericType<Integer> getJavaType() {
        return GenericType.INTEGER;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.INT;
    }

    @Override
    public boolean accepts(@NonNull Object value2) {
        return value2 instanceof Integer;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == Integer.class || javaClass == Integer.TYPE;
    }

    @Override
    @Nullable
    public ByteBuffer encodePrimitive(int value2, @NonNull ProtocolVersion protocolVersion) {
        ByteBuffer bytes2 = ByteBuffer.allocate(4);
        bytes2.putInt(0, value2);
        return bytes2;
    }

    @Override
    public int decodePrimitive(@Nullable ByteBuffer bytes2, @NonNull ProtocolVersion protocolVersion) {
        if (bytes2 == null || bytes2.remaining() == 0) {
            return 0;
        }
        if (bytes2.remaining() != 4) {
            throw new IllegalArgumentException("Invalid 32-bits integer value, expecting 4 bytes but got " + bytes2.remaining());
        }
        return bytes2.getInt(bytes2.position());
    }

    @Override
    @NonNull
    public String format(@Nullable Integer value2) {
        return value2 == null ? "NULL" : Integer.toString(value2);
    }

    @Override
    @Nullable
    public Integer parse(@Nullable String value2) {
        try {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Integer.valueOf(Integer.parseInt(value2));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse 32-bits int value from \"%s\"", value2));
        }
    }
}

